/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public abstract class AbstractSpringMigratorStep
extends AbstractApplicationModelMigrationStep {
    public static final String SPRING_FOLDER = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "spring" + File.separator;
    public static final String SPRING_NAMESPACE_PREFIX = "spring-module";
    public static final String SPRING_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/spring";
    public static final Namespace SPRING_NAMESPACE = Namespace.getNamespace((String)"spring-module", (String)"http://www.mulesoft.org/schema/mule/spring");
    public static final Namespace SPRING_SECURITY_NAMESPACE = Namespace.getNamespace((String)"mule-ss", (String)"http://www.mulesoft.org/schema/mule/spring-security");

    protected Document resolveSpringDocument(Document currentDoc) {
        Document springDocument = null;
        if ((springDocument = this.resolveSpringFile(currentDoc, springDocument, this.getApplicationModel().getApplicationDocuments())) == null && (springDocument = this.resolveSpringFile(currentDoc, springDocument, this.getApplicationModel().getDomainDocuments())) == null) {
            throw new MigrationStepException("The document of the passed element was not present in the application model");
        }
        return springDocument;
    }

    protected Document resolveSpringFile(Document currentDoc, Document springDocument, Map<Path, Document> artifactDocs) {
        Path beansPath = null;
        for (Map.Entry<Path, Document> entry : artifactDocs.entrySet()) {
            if (!currentDoc.equals((Object)entry.getValue())) continue;
            beansPath = this.resolveSpringBeansPath(entry);
            if (!artifactDocs.containsKey(Paths.get(SPRING_FOLDER + beansPath.getFileName().toString(), new String[0]))) continue;
            return artifactDocs.get(Paths.get(SPRING_FOLDER + beansPath.getFileName().toString(), new String[0]));
        }
        for (Map.Entry<Path, Document> entry : artifactDocs.entrySet()) {
            if (!currentDoc.equals((Object)entry.getValue())) continue;
            beansPath = this.resolveSpringBeansPath(entry);
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                springDocument = saxBuilder.build(AbstractSpringMigratorStep.class.getClassLoader().getResourceAsStream("spring/empty-beans.xml"));
            }
            catch (IOException | JDOMException e) {
                throw new MigrationStepException(e.getMessage(), e);
            }
            this.addSpringModuleConfig(currentDoc, "spring/" + beansPath.getFileName().toString());
            break;
        }
        if (beansPath == null) {
            return null;
        }
        artifactDocs.put(Paths.get(SPRING_FOLDER + beansPath.getFileName().toString(), new String[0]), springDocument);
        return springDocument;
    }

    protected void moveNamespacesDeclarations(Document muleDocument, Element movedElement, Document springDocument) {
        Set<Namespace> declaredNamespaces = this.doGetNamespacesDeclarationsRecursively(movedElement);
        Attribute schemaLocationAttribute = muleDocument.getRootElement().getAttribute("schemaLocation", muleDocument.getRootElement().getNamespace("xsi"));
        if (schemaLocationAttribute != null) {
            HashMap<String, String> locations = new HashMap<String, String>();
            String[] splitLocations = (String[])Arrays.stream(schemaLocationAttribute.getValue().split("\\s")).filter(s -> !StringUtils.isEmpty((CharSequence)s)).toArray(String[]::new);
            for (int i = 0; i < splitLocations.length; i += 2) {
                locations.put(splitLocations[i], splitLocations[i + 1]);
            }
            for (Namespace namespace : declaredNamespaces) {
                if (StringUtils.isEmpty((CharSequence)namespace.getURI()) || !locations.containsKey(namespace.getURI())) continue;
                this.getApplicationModel();
                ApplicationModel.addNameSpace((Namespace)namespace, (String)this.fixSpringSchemaLocationVersion((String)locations.get(namespace.getURI())), (Document)springDocument.getDocument());
            }
        }
    }

    private String fixSpringSchemaLocationVersion(String schemaLocation) {
        if (schemaLocation.startsWith("http://www.springframework.org/schema/") && schemaLocation.endsWith("-current.xsd")) {
            return schemaLocation.replace("-current.xsd", ".xsd");
        }
        return schemaLocation;
    }

    private Set<Namespace> doGetNamespacesDeclarationsRecursively(Element movedElement) {
        TreeSet<Namespace> declaredNamespaces = new TreeSet<Namespace>((o1, o2) -> o1.getURI().compareTo(o2.getURI()));
        declaredNamespaces.addAll(movedElement.getNamespacesIntroduced());
        for (Element child : movedElement.getChildren()) {
            declaredNamespaces.addAll(this.doGetNamespacesDeclarationsRecursively(child));
        }
        return declaredNamespaces;
    }

    protected void addSpringModuleConfig(Document document, String beansPath) {
        Element config = new Element("config", SPRING_NAMESPACE);
        String[] splitBeansPath = beansPath.split("\\/");
        config.setAttribute("name", StringUtils.substring((String)("springConfig_" + splitBeansPath[splitBeansPath.length - 1]), (int)0, (int)(-"-beans.xml".length())));
        config.setAttribute("files", beansPath);
        XmlDslUtils.addTopLevelElement((Element)config, (Document)document);
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)SPRING_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/spring/current/mule-spring.xsd", (Document)document);
    }

    private Path resolveSpringBeansPath(Map.Entry<Path, Document> entry) {
        if (entry.getKey().getParent() != null) {
            return entry.getKey().getParent().resolve(entry.getKey().getFileName().toString().replace(".xml", "-beans.xml"));
        }
        return Paths.get(entry.getKey().getFileName().toString().replace(".xml", "-beans.xml"), new String[0]);
    }
}

