/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.spring.AbstractSpringMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SpringBeans
extends AbstractSpringMigratorStep {
    private static final String SPRING_BEANS_NS_PREFIX = "spring";
    public static final String SPRING_BEANS_NS_URI = "http://www.springframework.org/schema/beans";
    private static final Namespace SPRING_BEANS_NS = Namespace.getNamespace((String)"spring", (String)"http://www.springframework.org/schema/beans");
    public static final String XPATH_SELECTOR = "/*[starts-with(namespace-uri(), 'http://www.mulesoft.org/schema/mule/')]/*[namespace-uri() = 'http://www.springframework.org/schema/beans' and local-name() != 'beans']";

    public String getDescription() {
        return "Migrates the spring beans form the mule config to its own file.";
    }

    public SpringBeans() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SPRING_BEANS_NS}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Document muleDocuemnt = object.getDocument();
        Document springDocument = this.resolveSpringDocument(muleDocuemnt);
        object.detach();
        springDocument.getRootElement().addContent((Content)object);
        this.moveNamespacesDeclarations(muleDocuemnt, object, springDocument);
    }
}

