/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.spring.AbstractSpringMigratorStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SpringContext
extends AbstractSpringMigratorStep {
    private static final String SPRING_CONTEXT_NS_PREFIX = "context";
    private static final String SPRING_CONTEXT_NS_URI = "http://www.springframework.org/schema/context";
    private static final Namespace SPRING_CONTEXT_NS = Namespace.getNamespace((String)"context", (String)"http://www.springframework.org/schema/context");
    public static final String XPATH_SELECTOR = "/*[starts-with(namespace-uri(), 'http://www.mulesoft.org/schema/mule/')]/*[namespace-uri()='http://www.springframework.org/schema/context' and local-name() != 'property-placeholder']";

    public String getDescription() {
        return "Migrates the spring context elements form the mule config to its own file.";
    }

    public SpringContext() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SPRING_CONTEXT_NS}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Document muleDocument = object.getDocument();
        Document springDocument = this.resolveSpringDocument(muleDocument);
        object.detach();
        springDocument.getRootElement().addContent((Content)object);
        this.moveNamespacesDeclarations(muleDocument, object, springDocument);
    }
}

