/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.vm;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.vm.AbstractVmEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class VmOutboundEndpoint
extends AbstractVmEndpoint {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/vm' and local-name()='outbound-endpoint']";

    public String getDescription() {
        return "Update VM transport outbound endpoint.";
    }

    public VmOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{VM_NAMESPACE}));
    }

    private String mapTransactionalAction(String action, MigrationReport report, Element tx, Element object) {
        if ("NONE".equals(action)) {
            return "NOT_SUPPORTED";
        }
        if ("ALWAYS_BEGIN".equals(action)) {
            report.report("vm.nestedTx", tx, object, new String[0]);
            return "ALWAYS_JOIN";
        }
        if ("BEGIN_OR_JOIN".equals(action)) {
            return "JOIN_IF_POSSIBLE";
        }
        return action;
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element tx = object.getChild("transaction", VM_NAMESPACE);
        while (tx != null) {
            object.setAttribute("transactionalAction", this.mapTransactionalAction(tx.getAttributeValue("action"), report, tx, object));
            object.removeChild("transaction", VM_NAMESPACE);
            tx = object.getChild("transaction", VM_NAMESPACE);
        }
        while (object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE) != null) {
            Element xaTx = object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
            object.setAttribute("transactionalAction", this.mapTransactionalAction(xaTx.getAttributeValue("action"), report, xaTx, object));
            object.removeChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
        }
        while (object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE) != null) {
            Element multiTx = object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
            object.setAttribute("transactionalAction", this.mapTransactionalAction(multiTx.getAttributeValue("action"), report, multiTx, object));
            object.removeChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
        }
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)VM_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/vm/current/mule-vm.xsd", (Document)object.getDocument());
        object.setNamespace(VM_NAMESPACE);
        if (object.getAttribute("exchange-pattern") == null || object.getAttributeValue("exchange-pattern").equals("one-way")) {
            object.setName("publish");
        } else {
            object.setName("publish-consume");
        }
        Optional<Element> connector = VmOutboundEndpoint.resolveVmConector(object, this.getApplicationModel());
        String configName = VmOutboundEndpoint.getVmConfigName(object, connector);
        Element vmConfig = VmOutboundEndpoint.migrateVmConfig(object, connector, configName, this.getApplicationModel());
        VmOutboundEndpoint.migrateOutboundVmEndpoint(object, report, connector, configName, vmConfig, this.getApplicationModel());
        TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true, (boolean)true);
    }

    public static void migrateOutboundVmEndpoint(Element object, MigrationReport report, Optional<Element> connector, String configName, Element vmConfig, ApplicationModel appModel) {
        String path = TransportsUtils.processAddress((Element)object, (MigrationReport)report).map(address -> address.getPath()).orElseGet(() -> VmOutboundEndpoint.obtainPath(object));
        VmOutboundEndpoint.addQueue(VM_NAMESPACE, connector, vmConfig, path);
        if (object.getAttribute("responseTimeout") != null) {
            object.setAttribute("timeout", object.getAttributeValue("responseTimeout"));
            object.setAttribute("timeoutUnit", "MILLISECONDS");
            object.removeAttribute("responseTimeout");
        }
        object.setAttribute("config-ref", configName);
        object.setAttribute("queueName", path);
        object.removeAttribute("path");
        object.removeAttribute("name");
        object.removeAttribute("mimeType");
        object.removeAttribute("disableTransportTransformer");
        if (!appModel.noCompatibilityMode()) {
            Element content = VmOutboundEndpoint.buildContent(VM_NAMESPACE);
            object.addContent((Content)content);
            report.report("vm.sessionVars", content, content, new String[0]);
        }
    }

    public static void migrateVmEndpointConsumer(Element object, MigrationReport report, Optional<Element> connector, String configName, Element vmConfig) {
        String path = TransportsUtils.processAddress((Element)object, (MigrationReport)report).map(address -> address.getPath()).orElseGet(() -> VmOutboundEndpoint.obtainPath(object));
        VmOutboundEndpoint.addQueue(VM_NAMESPACE, connector, vmConfig, path);
        if (object.getAttribute("responseTimeout") != null) {
            object.setAttribute("timeout", object.getAttributeValue("responseTimeout"));
            object.setAttribute("timeoutUnit", "MILLISECONDS");
            object.removeAttribute("responseTimeout");
        }
        object.setAttribute("config-ref", configName);
        object.setAttribute("queueName", path);
        object.removeAttribute("path");
        object.removeAttribute("name");
        object.removeAttribute("mimeType");
        object.removeAttribute("disableTransportTransformer");
    }
}

