/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.munit.steps;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.function.Function;
import org.jdom2.Attribute;
import org.jdom2.Element;

public abstract class AbstractAssertionMigration
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private ExpressionMigrator expressionMigrator;

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    protected void migrateExpression(Element element) {
        Attribute expression = element.getAttribute("expression");
        if (expression != null) {
            expression.setValue(this.getExpressionMigrator().migrateExpression(expression.getValue(), true, element));
        }
    }

    protected Function<Element, Element> updateMUnitAssertionEqualsExpression(String attributeName) {
        return e -> {
            Attribute attribute = e.getAttribute(attributeName);
            if (attribute != null) {
                String attributeValue = attribute.getValue();
                attributeValue = this.getExpressionMigrator().isWrapped(attributeValue) ? "#[MunitTools::equalTo(" + this.getExpressionMigrator().unwrap(attributeValue) + ")]" : "#[MunitTools::equalTo(" + attributeValue + ")]";
                attribute.setValue(attributeValue);
            }
            return e;
        };
    }

    protected Function<Element, Element> updateMUnitAssertionNotEqualsExpression(String attributeName) {
        return e -> {
            Attribute attribute = e.getAttribute(attributeName);
            if (attribute != null) {
                String attributeValue = attribute.getValue();
                attributeValue = this.getExpressionMigrator().isWrapped(attributeValue) ? "#[MunitTools::not(MUnitTools::equalTo(" + this.getExpressionMigrator().unwrap(attributeValue) + "))]" : "#[MunitTools::not(MUnitTools::equalTo(" + attributeValue + "))]";
                attribute.setValue(attributeValue);
            }
            return e;
        };
    }
}

