/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.nocompatibility;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.applicationgraph.ApplicationGraphCreator;
import com.mulesoft.tools.migration.library.applicationgraph.PropertiesSourceType;
import com.mulesoft.tools.migration.library.mule.steps.email.AbstractEmailSourceMigrator;
import com.mulesoft.tools.migration.library.mule.steps.file.FileInboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.ftp.FtpInboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpConnectorListener;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpConnectorRequester;
import com.mulesoft.tools.migration.library.mule.steps.jms.AbstractJmsEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.sftp.SftpInboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.wsc.WsConsumer;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertyTranslator;
import com.mulesoft.tools.migration.project.model.applicationgraph.SourceType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InboundToAttributesTranslator
implements PropertyTranslator {
    private static String ATTRIBUTES_PATTERN_REGEX = "[a-zA-Z0-9_\\-.'\\[\\]]*";
    private static Map<SourceType, Class> translatorClasses = new LinkedHashMap<SourceType, Class>();
    private Map<SourceType, Map<String, String>> applicationTranslations;

    public static List<SourceType> getSupportedConnectors() {
        return Lists.newArrayList(translatorClasses.keySet());
    }

    public void initializeTranslationsForApplicationSourceTypes(ApplicationModel applicationModel) {
        if (this.applicationTranslations == null) {
            LinkedHashMap<SourceType, Map<String, String>> result = new LinkedHashMap<SourceType, Map<String, String>>();
            List sourceNodes = applicationModel.getNodes("//" + ApplicationGraphCreator.MESSAGE_SOURCE_FILTER_EXPRESSION);
            for (SourceType sourceType : translatorClasses.keySet()) {
                if (!sourceNodes.stream().anyMatch(e -> sourceType.equals(new PropertiesSourceType(e.getNamespaceURI(), e.getName())))) continue;
                result.put(sourceType, this.getAllTranslationsFor(sourceType));
            }
            this.applicationTranslations = result;
        }
    }

    public Map<SourceType, Map<String, String>> getTranslationsForApplicationsSourceTypes() {
        return this.applicationTranslations;
    }

    public Map<String, String> getAllTranslationsFor(SourceType sourceType) {
        return this.getTranslationMap(sourceType).entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> InboundToAttributesTranslator.wrapWhenExpression((String)entry.getValue())));
    }

    public Map<SourceType, String> translateImplicit(String propertyToTranslate, Set<SourceType> originatingSourceTypes) {
        return originatingSourceTypes.stream().filter(s -> this.translateImplicit(propertyToTranslate, (SourceType)s) != null).collect(Collectors.toMap(Function.identity(), s -> this.translateImplicit(propertyToTranslate, (SourceType)s)));
    }

    public String translateImplicit(String propertyToTranslate, SourceType originatingSourceType) {
        String translation = null;
        if (propertyToTranslate != null && InboundToAttributesTranslator.isSupported(originatingSourceType) && originatingSourceType.supportsImplicit()) {
            translation = propertyToTranslate.contains(".") ? String.format("%s.%s['%s']", "message.attributes", originatingSourceType.getImplicitPrefix(), propertyToTranslate) : String.format("%s.%s.%s", "message.attributes", originatingSourceType.getImplicitPrefix(), propertyToTranslate);
        }
        translation = InboundToAttributesTranslator.wrapWhenExpression(translation);
        return translation;
    }

    public Map<String, String> getTranslationMap(SourceType originatingSourceType) {
        Class translatorClazz = translatorClasses.get(originatingSourceType);
        if (translatorClazz != null) {
            try {
                return (Map)translatorClazz.getMethod("inboundToAttributesExpressions", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String wrapWhenExpression(String translation) {
        if (translation != null && !translation.matches(ATTRIBUTES_PATTERN_REGEX)) {
            return String.format("(%s)", translation);
        }
        return translation;
    }

    private static boolean isSupported(SourceType originatingSourceType) {
        return translatorClasses.keySet().contains(originatingSourceType);
    }

    static {
        translatorClasses.put(PropertiesSourceType.HTTP_LISTENER, HttpConnectorListener.class);
        translatorClasses.put(PropertiesSourceType.HTTP_TRANSPORT, HttpConnectorListener.class);
        translatorClasses.put(PropertiesSourceType.HTTP_CONNECTOR_REQUESTER, HttpConnectorRequester.class);
        translatorClasses.put(PropertiesSourceType.HTTP_TRANSPORT_OUTBOUND, HttpConnectorRequester.class);
        translatorClasses.put(PropertiesSourceType.HTTP_POLLING_CONNECTOR, HttpConnectorRequester.class);
        translatorClasses.put(PropertiesSourceType.FILE_INBOUND, FileInboundEndpoint.class);
        translatorClasses.put(PropertiesSourceType.IMAP_INBOUND, AbstractEmailSourceMigrator.class);
        translatorClasses.put(PropertiesSourceType.POP3_INBOUND, AbstractEmailSourceMigrator.class);
        translatorClasses.put(PropertiesSourceType.FTP_INBOUND, FtpInboundEndpoint.class);
        translatorClasses.put(PropertiesSourceType.JMS_INBOUND, AbstractJmsEndpoint.class);
        translatorClasses.put(PropertiesSourceType.JMS_OUTBOUND, AbstractJmsEndpoint.class);
        translatorClasses.put(PropertiesSourceType.REQUEST_REPLY, AbstractJmsEndpoint.class);
        translatorClasses.put(PropertiesSourceType.QUARTZ_INBOUND, AbstractJmsEndpoint.class);
        translatorClasses.put(PropertiesSourceType.SFTP_INBOUND, SftpInboundEndpoint.class);
        translatorClasses.put(PropertiesSourceType.WS_CONSUMER, WsConsumer.class);
    }
}

