/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools;

import com.mulesoft.tools.JavaModuleRequired;
import com.mulesoft.tools.MigratableWithWarning;
import com.mulesoft.tools.MigrationResult;
import com.mulesoft.tools.Migrator;
import com.mulesoft.tools.NonMigratable;
import com.mulesoft.tools.migration.library.tools.PluginsVersions;
import com.mulesoft.tools.migration.library.tools.TemplateParser;
import com.mulesoft.tools.migration.library.tools.mel.DefaultMelCompatibilityResolver;
import com.mulesoft.tools.migration.library.tools.mel.MelCompatibilityResolver;
import com.mulesoft.tools.migration.library.tools.mel.nocompatibility.MelNoCompatibilityResolver;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class MelToDwExpressionMigrator
implements ExpressionMigrator {
    private static Logger logger = LoggerFactory.getLogger(MelToDwExpressionMigrator.class);
    private final MigrationReport report;
    private final Pattern EXPRESSION_WRAPPER = Pattern.compile("^\\s*#\\[(.*)]\\s*$", 32);
    private final Pattern EXPRESSION_TEMPLATE_WRAPPER = Pattern.compile(".*#\\[(.*)].*", 32);
    private MelCompatibilityResolver compatibilityResolver;
    private MelNoCompatibilityResolver noCompatibilityResolver;
    private final ApplicationModel model;

    public MelToDwExpressionMigrator(MigrationReport report, ApplicationModel model) {
        this.report = report;
        this.model = model;
        if (model.noCompatibilityMode()) {
            this.noCompatibilityResolver = new MelNoCompatibilityResolver();
        } else {
            this.compatibilityResolver = new MelCompatibilityResolver();
        }
    }

    public String migrateExpression(String originalExpression, boolean dataWeaveBodyOnly, Element element) {
        return this.migrateExpression(originalExpression, dataWeaveBodyOnly, element, false);
    }

    public String migrateExpression(String originalExpression, boolean dataWeaveBodyOnly, Element element, boolean enricher) {
        String migratedExpression;
        if (!this.isWrapped(originalExpression) && !originalExpression.contains("#[")) {
            return originalExpression;
        }
        String unwrapped = this.unwrap(originalExpression);
        if (!(unwrapped = unwrapped.replaceAll("mel:", "")).contains("#[")) {
            migratedExpression = this.wrap(this.translateSingleExpression(unwrapped, dataWeaveBodyOnly, element, enricher));
        } else {
            TemplateParser muleStyleParser = TemplateParser.createMuleStyleParser();
            migratedExpression = muleStyleParser.translate(originalExpression, script -> this.translateSingleExpression(script, dataWeaveBodyOnly, element, enricher));
            if (migratedExpression.contains("mel:")) {
                XmlDslUtils.addCompatibilityNamespace((Document)element.getDocument());
            }
        }
        return StringUtils.replaceAll((String)migratedExpression, (String)"\\r\\n|[\\r\\n]", (String)" ");
    }

    public String translateSingleExpression(String unwrappedExpression, boolean dataWeaveBodyOnly, Element element, boolean enricher) {
        String migratedExpression;
        MigrationResult result;
        logger.debug("  --->> Evaluating MEL expression at element {} -> {}", (Object)(element != null ? element.getName() : "null"), (Object)unwrappedExpression);
        try {
            result = Migrator.migrate((String)unwrappedExpression);
            migratedExpression = result.getGeneratedCode();
        }
        catch (Exception e) {
            if (this.noCompatibilityResolver != null) {
                return this.noCompatibilityResolver.resolve(unwrappedExpression, element, this.report, this.model, this, enricher).getTranslation();
            }
            return this.compatibilityResolver.resolve(unwrappedExpression, element, this.report, this.model, this, enricher);
        }
        if (result.metadata().children().exists(a -> a instanceof NonMigratable)) {
            List<NonMigratable> metadata = JavaConverters.seqAsJavaList((Seq)result.metadata().children()).stream().filter(a -> a instanceof NonMigratable).collect(Collectors.toList());
            metadata.forEach(a -> this.report.report(a.reason(), element, element, new String[0]));
            return (String)new DefaultMelCompatibilityResolver().resolve(unwrappedExpression, element, this.report, this.model, this, enricher);
        }
        if (result.metadata().children().exists(a -> a instanceof MigratableWithWarning)) {
            List<MigratableWithWarning> metadata = JavaConverters.seqAsJavaList((Seq)result.metadata().children()).stream().filter(a -> a instanceof MigratableWithWarning).collect(Collectors.toList());
            metadata.forEach(a -> this.report.report(a.warning(), element, element, new String[0]));
        }
        if (migratedExpression.contains("message.inboundAttachments")) {
            this.report.report("message.expressionsAttachments", element, element, new String[0]);
        }
        if (result.metadata().children().exists(a -> a instanceof JavaModuleRequired)) {
            Dependency javaModuleDependency = new Dependency.DependencyBuilder().withGroupId("org.mule.module").withArtifactId("mule-java-module").withVersion(PluginsVersions.targetVersion("mule-java-module")).withClassifier("mule-plugin").build();
            this.model.getPomModel().ifPresent(m -> m.addDependency(javaModuleDependency));
        }
        migratedExpression = this.resolveServerContext(migratedExpression);
        if (dataWeaveBodyOnly) {
            migratedExpression = migratedExpression.replaceFirst(String.format("%%dw 2\\.0%s---", System.lineSeparator()), "").trim();
        }
        if (this.noCompatibilityResolver != null) {
            try {
                migratedExpression = this.noCompatibilityResolver.resolve(migratedExpression, element, this.report, this.model, this, enricher).getTranslation();
            }
            catch (Exception e) {
                return this.resolveIdentifiersAndEscape(migratedExpression, dataWeaveBodyOnly);
            }
        } else {
            migratedExpression = this.resolveCompatibilityIdentifiers(migratedExpression);
            this.report.melExpressionSuccess(unwrappedExpression);
        }
        return this.resolveIdentifiersAndEscape(migratedExpression, dataWeaveBodyOnly);
    }

    private String resolveIdentifiersAndEscape(String migratedExpression, boolean dataWeaveBodyOnly) {
        migratedExpression = this.resolveIdentifiers(migratedExpression);
        return this.escapeUnderscores(migratedExpression);
    }

    private String resolveServerContext(String expression) {
        return expression.replaceAll("(vars\\.)?server\\.dateTime", "now()").replaceAll("(vars\\.)?server\\.nanoSeconds", "System.nanoTime()").replaceAll("(vars\\.)?server\\.ip", "server.ip").replaceAll("(vars\\.)?server\\.host", "server.host");
    }

    public String resolveCompatibilityIdentifiers(String expression) {
        return expression.replaceAll("message\\.inboundProperties", "vars.compatibility_inboundProperties").replaceAll("message\\.outboundProperties", "vars.compatibility_outboundProperties");
    }

    public String resolveIdentifiers(String expression) {
        return expression.replaceAll("flowVars", "vars").replaceAll("recordVars", "vars").replaceAll("message\\.id", "correlationId").replaceAll("message\\.inboundAttachments", "payload.parts").replaceAll("message\\.dataType\\.mimeType", "message.^mediaType").replaceAll("message\\.dataType\\.encoding", "message.^encoding");
    }

    private String escapeUnderscores(String expression) {
        return Arrays.stream(expression.split("\\.")).map(part -> part.startsWith("_") ? String.format("'%s'", part) : part).collect(Collectors.joining("."));
    }

    public String unwrap(String originalExpression) {
        this.checkExpression(originalExpression);
        Matcher wrappedExpressionMatcher = this.EXPRESSION_WRAPPER.matcher(originalExpression);
        if (wrappedExpressionMatcher.matches()) {
            return this.unwrap(wrappedExpressionMatcher.group(1).trim());
        }
        return originalExpression;
    }

    public String wrap(String originalExpression) {
        this.checkExpression(originalExpression);
        return this.isWrapped(originalExpression) ? originalExpression : "#[" + originalExpression + "]";
    }

    public boolean isWrapped(String originalExpression) {
        this.checkExpression(originalExpression);
        return this.EXPRESSION_WRAPPER.matcher(originalExpression).matches();
    }

    public boolean isTemplate(String originalExpression) {
        this.checkExpression(originalExpression);
        return this.EXPRESSION_TEMPLATE_WRAPPER.matcher(originalExpression).matches();
    }

    private void checkExpression(String expression) {
        Objects.requireNonNull(expression, "Expression cannot be null");
    }
}

