/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools.mel;

import com.mulesoft.tools.migration.library.tools.mel.DefaultMelCompatibilityResolver;
import com.mulesoft.tools.migration.library.tools.mel.HeaderSyntaxCompatibilityResolver;
import com.mulesoft.tools.migration.library.tools.mel.InboundAttachmentsCompatibilityResolver;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class MelCompatibilityResolver
implements CompatibilityResolver<String> {
    private List<CompatibilityResolver<String>> resolvers = new ArrayList<CompatibilityResolver<String>>();

    public MelCompatibilityResolver() {
        this.resolvers.add(new InboundAttachmentsCompatibilityResolver());
        this.resolvers.add(new HeaderSyntaxCompatibilityResolver());
    }

    public boolean canResolve(String original) {
        return true;
    }

    public String resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator) {
        return (String)this.lookupResolver(original).resolve(original, element, report, model, expressionMigrator);
    }

    public String resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator, boolean enricher) {
        return (String)this.lookupResolver(original).resolve(original, element, report, model, expressionMigrator, enricher);
    }

    protected CompatibilityResolver<String> lookupResolver(String original) {
        CompatibilityResolver resolver = this.resolvers.stream().filter(r -> r.canResolve(original)).findFirst().orElse(new DefaultMelCompatibilityResolver());
        return resolver;
    }
}

