/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools.mel.nocompatibility;

import com.google.common.collect.ImmutableList;
import com.mulesoft.tools.migration.library.tools.mel.nocompatibility.PropertiesNoCompatibilityResolver;
import com.mulesoft.tools.migration.project.model.applicationgraph.ApplicationGraph;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertiesMigrationContext;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertyTranslator;
import java.util.List;
import java.util.regex.Pattern;

public class InboundPropertiesNoCompatibilityResolver
extends PropertiesNoCompatibilityResolver {
    private static final Pattern INBOUND_MAP_PATTERN = Pattern.compile("(message\\.inboundProperties[^\\[|\\.]+[$]*)");
    private static final Pattern GENERAL_INBOUND_PATTERN = Pattern.compile("(message\\.inboundProperties(?:\\.'?[\\.a-zA-Z0-9]*'?|\\['?.*'+?\\]))");
    private static final Pattern INBOUND_PATTERN_WITH_BRACKETS = Pattern.compile("message\\.inboundProperties\\['(.*?)'\\]");
    private static final Pattern INBOUND_PATTERN_WITH_DOT = Pattern.compile("message\\.inboundProperties\\.'?(.*?)'?");
    private static final Pattern INBOUND_PATTERN_WITH_HEADER = Pattern.compile("(?i)^header:inbound:");
    private static final Pattern INBOUND_PATTERN_WITH_EXPRESSION = Pattern.compile("message\\.inboundProperties\\['(.*)'\\]");
    private static final Pattern INBOUND_PATTERN_ONLY_EXPRESSION = Pattern.compile("message\\.inboundProperties\\[[^'].*\\]");

    public InboundPropertiesNoCompatibilityResolver() {
        super(INBOUND_MAP_PATTERN, GENERAL_INBOUND_PATTERN, (List<Pattern>)ImmutableList.of((Object)INBOUND_PATTERN_WITH_BRACKETS, (Object)INBOUND_PATTERN_WITH_DOT, (Object)INBOUND_PATTERN_WITH_HEADER), INBOUND_PATTERN_WITH_EXPRESSION, INBOUND_PATTERN_ONLY_EXPRESSION);
    }

    @Override
    protected PropertyTranslator getTranslator(ApplicationGraph graph) {
        return graph.getInboundTranslator();
    }

    @Override
    protected List<String> getPropertyTranslations(PropertiesMigrationContext context, String propertyToTranslate, PropertyTranslator translator) {
        return context.getInboundTranslation(propertyToTranslate);
    }
}

