/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools.mel.nocompatibility;

import com.mulesoft.tools.migration.library.tools.mel.nocompatibility.InboundPropertiesNoCompatibilityResolver;
import com.mulesoft.tools.migration.library.tools.mel.nocompatibility.NoCompatibilityResolverResult;
import com.mulesoft.tools.migration.library.tools.mel.nocompatibility.OutboundPropertiesNoCompatibilityResolver;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom2.Element;

public class MelNoCompatibilityResolver
implements CompatibilityResolver<NoCompatibilityResolverResult> {
    protected List<CompatibilityResolver<NoCompatibilityResolverResult>> resolvers = new ArrayList<CompatibilityResolver<NoCompatibilityResolverResult>>();

    public MelNoCompatibilityResolver() {
        this.resolvers.add(new InboundPropertiesNoCompatibilityResolver());
        this.resolvers.add(new OutboundPropertiesNoCompatibilityResolver());
    }

    public boolean canResolve(String original) {
        return true;
    }

    public NoCompatibilityResolverResult resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator) {
        return this.resolve(original, element, report, model, expressionMigrator, false);
    }

    public NoCompatibilityResolverResult resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator, boolean enricher) {
        List<CompatibilityResolver<NoCompatibilityResolverResult>> matchedResolvers = this.lookupResolvers(original);
        NoCompatibilityResolverResult resolverResult = null;
        String resolvedExpression = original;
        boolean markedAsSuccess = true;
        for (CompatibilityResolver<NoCompatibilityResolverResult> resolver : matchedResolvers) {
            resolverResult = (NoCompatibilityResolverResult)resolver.resolve(resolvedExpression, element, report, model, expressionMigrator);
            if (!resolverResult.isSuccesful()) {
                markedAsSuccess = false;
            }
            resolvedExpression = resolverResult.getTranslation();
        }
        if (markedAsSuccess) {
            report.melExpressionSuccess(original);
        } else {
            report.melExpressionFailure(original);
        }
        return new NoCompatibilityResolverResult(resolvedExpression, markedAsSuccess);
    }

    protected List<CompatibilityResolver<NoCompatibilityResolverResult>> lookupResolvers(String original) {
        List<CompatibilityResolver<NoCompatibilityResolverResult>> matchedResolvers = this.resolvers.stream().filter(r -> r.canResolve(original)).collect(Collectors.toList());
        return matchedResolvers;
    }
}

