/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools.mel.nocompatibility;

import com.mulesoft.tools.migration.exception.MigrationException;
import com.mulesoft.tools.migration.library.tools.mel.nocompatibility.NoCompatibilityResolverResult;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.applicationgraph.ApplicationGraph;
import com.mulesoft.tools.migration.project.model.applicationgraph.FlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertiesMigrationContext;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertyTranslator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;

public abstract class PropertiesNoCompatibilityResolver
implements CompatibilityResolver<NoCompatibilityResolverResult> {
    private Pattern mapPattern;
    private Pattern generalPattern;
    private List<Pattern> singleExpressionPatterns;
    private Pattern patternWithExpression;
    private Pattern patternWithOnlyExpression;

    public PropertiesNoCompatibilityResolver(Pattern mapPattern, Pattern generalPattern, List<Pattern> singleExpressionPatterns, Pattern patternWithExpression, Pattern patternWithOnlyExpression) {
        this.mapPattern = mapPattern;
        this.generalPattern = generalPattern;
        this.singleExpressionPatterns = singleExpressionPatterns;
        this.patternWithExpression = patternWithExpression;
        this.patternWithOnlyExpression = patternWithOnlyExpression;
    }

    public boolean canResolve(String original) {
        return original != null && (this.generalPattern.matcher(original).find() || this.mapPattern.matcher(original).matches());
    }

    public NoCompatibilityResolverResult resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator) {
        String translatedExpression = original;
        boolean success = true;
        if (model.noCompatibilityMode()) {
            try {
                if (this.mapPattern.matcher(original).matches()) {
                    report.report("noCompatibility.mapPattern", element, element, new String[]{element.getName()});
                    success = false;
                }
                translatedExpression = this.translatePropertyReferences(original, element, report, model.getApplicationGraph());
            }
            catch (MigrationException e) {
                success = false;
            }
            catch (Exception e) {
                report.report("noCompatibility.unsupportedProperty", element.getParentElement(), element.getParentElement(), new String[]{element.getName()});
                success = false;
            }
        }
        return new NoCompatibilityResolverResult(translatedExpression, success);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String translatePropertyReferences(String expression, Element element, MigrationReport report, ApplicationGraph applicationGraph) throws Exception {
        String elementName = element.getName();
        FlowComponent flowComponent = applicationGraph.findFlowComponent(element);
        Matcher matcher = this.generalPattern.matcher(expression);
        if (flowComponent != null) {
            try {
                if (matcher.find()) {
                    return this.replaceAllOccurencesOfProperty(element, expression, matcher, flowComponent, report, this.getTranslator(applicationGraph));
                }
                matcher = this.patternWithExpression.matcher(expression);
                if (!matcher.find()) return expression;
                report.report("noCompatibility.melExpression", element, element, new String[]{elementName});
                report.melExpressionFailure(expression);
                return expression;
            }
            catch (MigrationException e) {
                throw e;
            }
            catch (Exception e) {
                report.report("noCompatibility.unsupportedProperty", element, element, new String[]{elementName});
                throw new MigrationException(e.getMessage());
            }
        } else {
            report.report("noCompatibility.unsupportedProperty", element, element, new String[]{elementName});
            throw new MigrationException("There was an issue trying to resolve expression to no compatibility. Application graph is not correctly populated");
        }
    }

    private String replaceAllOccurencesOfProperty(Element element, String content, Matcher outerMatcher, FlowComponent flowComponent, MigrationReport report, PropertyTranslator translator) throws MigrationException {
        outerMatcher.reset();
        String contentTranslation = content;
        boolean failedCompleteTranslation = false;
        while (outerMatcher.find()) {
            String referenceToProperty = outerMatcher.group();
            Matcher specificPropMatcher = this.singleExpressionPatterns.get(0).matcher(referenceToProperty);
            for (int it = 1; !specificPropMatcher.matches() && it < this.singleExpressionPatterns.size(); ++it) {
                specificPropMatcher = this.singleExpressionPatterns.get(it).matcher(referenceToProperty);
            }
            if (specificPropMatcher.matches()) {
                if (this.containsExpression(referenceToProperty)) {
                    report.report("noCompatibility.unsupportedProperty", element, element, new String[]{element.getName()});
                    failedCompleteTranslation = true;
                }
                String propertyToTranslate = specificPropMatcher.group(1);
                String propertyTranslation = null;
                try {
                    List<String> possibleTranslations = this.getPropertyTranslations(flowComponent.getPropertiesMigrationContext(), propertyToTranslate, translator);
                    if (possibleTranslations != null && possibleTranslations.size() > 0) {
                        propertyTranslation = possibleTranslations.get(0);
                    }
                    if (possibleTranslations.size() > 1) {
                        report.report("noCompatibility.collidingProperties", element, element, new String[]{propertyToTranslate});
                    }
                    if (propertyTranslation == null) {
                        report.report("noCompatibility.unsupportedProperty", element, element, new String[]{element.getName()});
                        failedCompleteTranslation = true;
                    }
                    if (propertyTranslation != null) {
                        contentTranslation = content.replace(specificPropMatcher.group(0), propertyTranslation);
                    }
                }
                catch (Exception e) {
                    report.report("noCompatibility.unsupportedProperty", element, element, new String[]{element.getName()});
                    failedCompleteTranslation = true;
                }
            }
            if (!failedCompleteTranslation) continue;
            throw new MigrationException("Failed to translate all occurrences of properties");
        }
        return contentTranslation;
    }

    private boolean containsExpression(String referenceToProperty) {
        return referenceToProperty.matches(this.patternWithOnlyExpression.pattern());
    }

    protected abstract PropertyTranslator getTranslator(ApplicationGraph var1);

    protected abstract List<String> getPropertyTranslations(PropertiesMigrationContext var1, String var2, PropertyTranslator var3);
}

