/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.applicationgraph;

import com.mulesoft.tools.migration.project.model.applicationgraph.DummyFlowRefReturnComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.DummyFlowTerminalComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.Flow;
import com.mulesoft.tools.migration.project.model.applicationgraph.FlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.FlowRefFlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.MessageSourceFlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertyTranslator;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdom2.Element;

public class ApplicationGraph {
    private final PropertyTranslator inboundTranslator;
    private final Map<String, FlowComponent> flowComponentIds = new HashMap<String, FlowComponent>();
    private final List<MessageSourceFlowComponent> sources = new ArrayList<MessageSourceFlowComponent>();
    private List<Flow> applicationFlows;

    public ApplicationGraph(PropertyTranslator translator, List<Flow> applicationFlows) {
        this.inboundTranslator = translator;
        this.applicationFlows = applicationFlows;
    }

    public FlowComponent findFlowComponent(Element element) {
        String elementId = element.getAttributeValue("migrationId", XmlDslUtils.MIGRATION_NAMESPACE);
        FlowComponent flowComponent = this.findFlowComponent(elementId);
        while (flowComponent == null && element.getParentElement() != null && !element.getParentElement().getName().equals("flow")) {
            element = element.getParentElement();
            elementId = element.getAttributeValue("migrationId", XmlDslUtils.MIGRATION_NAMESPACE);
            flowComponent = this.findFlowComponent(elementId);
        }
        return flowComponent;
    }

    private FlowComponent findFlowComponent(String elementId) {
        return this.flowComponentIds.get(elementId);
    }

    public void linealFlowWiring(Flow flow) {
        List<FlowComponent> flowComponents = flow.getComponents();
        if (flowComponents.isEmpty()) {
            return;
        }
        FlowComponent firstFlowComponent = flowComponents.get(0);
        if (firstFlowComponent instanceof MessageSourceFlowComponent) {
            this.sources.add((MessageSourceFlowComponent)firstFlowComponent);
            flowComponents.add(DummyFlowTerminalComponent.build(flow, this));
        } else if (flowComponents.get(flowComponents.size() - 1) instanceof FlowRefFlowComponent) {
            flowComponents.add(DummyFlowRefReturnComponent.build(flow, this));
        }
        FlowComponent previousFlowComp = null;
        for (FlowComponent comp : flowComponents) {
            this.flowComponentIds.put(comp.getElementId(), comp);
            if (previousFlowComp != null) {
                previousFlowComp.next(comp);
            }
            previousFlowComp = comp;
        }
    }

    public void muleFlowWiring() {
        ArrayDeque flowStack = new ArrayDeque();
        for (MessageSourceFlowComponent source : this.sources) {
            FlowComponent current = source;
            flowStack.clear();
            while (!(current instanceof DummyFlowTerminalComponent)) {
                current = (FlowComponent)current.rewire(flowStack);
            }
            source.setTerminalComponent(current);
            this.flowComponentIds.put(current.getElementId(), current);
        }
    }

    public PropertyTranslator getInboundTranslator() {
        return this.inboundTranslator;
    }

    public Map<String, FlowComponent> getFlowComponentIds() {
        return new HashMap<String, FlowComponent>(this.flowComponentIds);
    }

    public Optional<Flow> getFlow(String flowName) {
        return this.applicationFlows.stream().filter(f -> f.getName().equals(flowName)).findFirst();
    }
}

