/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.applicationgraph;

import com.mulesoft.tools.migration.project.model.applicationgraph.ApplicationGraph;
import com.mulesoft.tools.migration.project.model.applicationgraph.DummyFlowTerminalComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.Flow;
import com.mulesoft.tools.migration.project.model.applicationgraph.FlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.FlowRefFlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.InvalidGraphStateException;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertiesMigrationContext;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFlowComponent
implements FlowComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicFlowComponent.class);
    protected final Deque<FlowComponent> next = new ArrayDeque<FlowComponent>();
    protected final Deque<FlowComponent> previous = new ArrayDeque<FlowComponent>();
    protected final Element element;
    protected final Flow flow;
    protected final ApplicationGraph applicationGraph;
    protected PropertiesMigrationContext inputContext;
    protected PropertiesMigrationContext outputContext;
    protected FlowRefFlowComponent flowRefCaller;

    public BasicFlowComponent(Element xmlElement, Flow parentFLow, ApplicationGraph applicationGraph) {
        Objects.requireNonNull(xmlElement);
        Objects.requireNonNull(parentFLow);
        Objects.requireNonNull(applicationGraph);
        this.element = xmlElement;
        this.flow = parentFLow;
        this.applicationGraph = applicationGraph;
        this.inputContext = new PropertiesMigrationContext(applicationGraph.getInboundTranslator());
    }

    @Override
    public String getElementId() {
        return this.element.getAttributeValue("migrationId", XmlDslUtils.MIGRATION_NAMESPACE);
    }

    @Override
    public Flow getParentFlow() {
        return this.flow;
    }

    @Override
    public Element getXmlElement() {
        return this.element;
    }

    @Override
    public PropertiesMigrationContext getPropertiesMigrationContext() {
        return this.getInputContext();
    }

    public PropertiesMigrationContext getInputContext() {
        return this.inputContext;
    }

    public PropertiesMigrationContext getOutputContext() {
        return this.outputContext;
    }

    @Override
    public String getName() {
        String ns = this.element.getNamespace().getPrefix();
        return String.format("%s%s//%s//%s", ns.isEmpty() ? "" : ns + ":", this.element.getName(), this.flow.getName(), this.getElementId().substring(0, 4));
    }

    @Override
    public void next(FlowComponent nextComponent) {
        this.next.addFirst(nextComponent);
        ((BasicFlowComponent)nextComponent).previous.addFirst(this);
    }

    @Override
    public void resetNext(FlowComponent nextComponent) {
        new ArrayList<FlowComponent>(this.next()).forEach(fc -> {
            this.next().remove(fc);
            fc.previous().remove(this);
        });
        this.next(nextComponent);
    }

    @Override
    public Deque<FlowComponent> next() {
        return this.next;
    }

    @Override
    public Deque<FlowComponent> previous() {
        return this.previous;
    }

    @Override
    public FlowComponent rewire(Deque<Flow> flowStack) {
        this.updatePropertiesContext();
        return this.nextComponentToProcess(flowStack);
    }

    public FlowComponent nextComponentToProcess(Deque<Flow> flowStack) {
        if (this.flowRefCaller != null) {
            flowStack.remove(this.getParentFlow());
        }
        FlowComponent nextComponent = this.next.peek();
        if (this.next.size() > 1) {
            Optional<FlowComponent> any = this.next.stream().filter(fc -> fc.getParentFlow().equals(flowStack.peekLast())).findAny();
            if (any.isPresent()) {
                nextComponent = any.get();
            } else {
                LOGGER.warn("Could not find next component for {}", (Object)this);
            }
        }
        if (nextComponent instanceof DummyFlowTerminalComponent) {
            ((DummyFlowTerminalComponent)nextComponent).updatePropertiesContext();
        }
        if (this instanceof FlowRefFlowComponent && !this.getParentFlow().equals(nextComponent.getParentFlow())) {
            if (flowStack.contains(this.getParentFlow())) {
                throw new InvalidGraphStateException("Loop detected");
            }
            flowStack.offer(this.getParentFlow());
        }
        LOGGER.debug("Current flow stack: {}", flowStack);
        return nextComponent;
    }

    public void updatePropertiesContext() {
        this.updatePropertiesContext(null);
    }

    public void updatePropertiesContext(PropertiesMigrationContext outputContext) {
        if (this.previous.isEmpty()) {
            LOGGER.warn("No previous nodes");
            return;
        }
        this.inputContext = this.flowRefCaller != null ? (this.previous.peek().getPropertiesMigrationContext().hasSingleSourceType() ? ((BasicFlowComponent)this.previous.peek()).getOutputContext() : this.flowRefCaller.getOutputContext()) : (this.previous.size() > 1 ? PropertiesMigrationContext.mergeContexts(this.applicationGraph.getInboundTranslator(), this.previous) : ((BasicFlowComponent)this.previous.peek()).getOutputContext());
        this.outputContext = outputContext != null ? outputContext : this.inputContext;
        LOGGER.debug("context for node {} -- inputCtx: {} -- outputCtx: {}", new Object[]{this, this.inputContext, this.outputContext});
    }

    public String toString() {
        return this.getName();
    }
}

