/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.applicationgraph;

import com.mulesoft.tools.migration.project.model.applicationgraph.FlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertyTranslator;
import com.mulesoft.tools.migration.project.model.applicationgraph.SourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesMigrationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesMigrationContext.class);
    private final PropertyTranslator inboundTranslator;
    private final Set<SourceType> sourceTypes = new TreeSet<SourceType>();

    public PropertiesMigrationContext(PropertyTranslator inboundTranslator) {
        this(inboundTranslator, null);
    }

    public PropertiesMigrationContext(PropertyTranslator inboundTranslator, SourceType sourceType) {
        this.inboundTranslator = inboundTranslator;
        if (sourceType != null) {
            this.sourceTypes.add(sourceType);
        }
    }

    public static PropertiesMigrationContext mergeContexts(PropertyTranslator inboundTranslator, Deque<FlowComponent> flowComponents) {
        return flowComponents.stream().map(FlowComponent::getPropertiesMigrationContext).reduce(new PropertiesMigrationContext(inboundTranslator), (a, b) -> {
            a.sourceTypes.addAll(b.sourceTypes);
            return a;
        });
    }

    public List<String> getInboundTranslation(String key) {
        List<String> result = this.sourceTypes.stream().filter(s -> this.inboundTranslator.getAllTranslationsFor((SourceType)s).containsKey(key)).map(s -> this.inboundTranslator.getAllTranslationsFor((SourceType)s).get(key)).collect(Collectors.toList());
        if (result.isEmpty()) {
            result = this.inboundTranslator.getTranslationsForApplicationsSourceTypes().values().stream().filter(m -> m.containsKey(key)).map(m -> (String)m.get(key)).collect(Collectors.toList());
        }
        if (result.isEmpty()) {
            result = new ArrayList<String>(this.inboundTranslator.translateImplicit(key, this.sourceTypes).values());
        }
        return result;
    }

    public boolean hasSingleSourceType() {
        if (this.sourceTypes.isEmpty()) {
            LOGGER.warn("No source types set");
        }
        return this.sourceTypes.size() == 1;
    }

    public List<String> getOutboundTranslation(String key) {
        return Collections.singletonList(PropertyTranslator.outboundVariableExpression(key));
    }

    public String toString() {
        return this.sourceTypes.toString();
    }
}

