/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.artifact;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.mulesoft.tools.migration.project.model.artifact.MuleArtifactJsonModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.Product;

public class MuleArtifactJsonModelUtils {
    public static final Charset MULE_ARTIFACT_DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String MULE_ID = "mule";

    public static MuleArtifactJsonModel buildMule4ArtifactJson(String name, Collection<Path> configs, String muleVersion) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setName(name);
        builder.setSecureProperties((List)Lists.newArrayList());
        builder.setRedeploymentEnabled(true);
        builder.setMinMuleVersion(muleVersion);
        builder.setRequiredProduct(Product.MULE_EE);
        if (configs != null && !configs.isEmpty()) {
            HashSet configsNames = new HashSet();
            configs.forEach(c -> configsNames.add(c.getFileName().toString()));
            builder.setConfigs(configsNames);
        } else {
            builder.setConfigs(null);
        }
        MuleArtifactLoaderDescriptor descriptor = new MuleArtifactLoaderDescriptorBuilder().setId(MULE_ID).build();
        builder.withClassLoaderModelDescriptorLoader(descriptor);
        MuleArtifactLoaderDescriptor loaderDescriptor = new MuleArtifactLoaderDescriptorBuilder().setId(MULE_ID).build();
        builder.withBundleDescriptorLoader(loaderDescriptor);
        return new MuleArtifactJsonModel((MuleApplicationModel)builder.build());
    }

    public static MuleArtifactJsonModel buildMinimalMuleArtifactJson(String minMuleVersion) {
        String muleApplicationModelJson = String.format("{ \"minMuleVersion\": \"%s\" }", minMuleVersion);
        return new MuleArtifactJsonModel(muleApplicationModelJson);
    }

    public static MuleArtifactJsonModel buildMinimalMuleArtifactJson(String minMuleVersion, List<String> secureProperties) {
        if (secureProperties == null || secureProperties.isEmpty()) {
            return MuleArtifactJsonModelUtils.buildMinimalMuleArtifactJson(minMuleVersion);
        }
        secureProperties = secureProperties.stream().map(prop -> "\"" + prop + "\"").collect(Collectors.toList());
        String muleApplicationModelJson = String.format("{ \"minMuleVersion\": \"%s\", \"secureProperties\": %s }", minMuleVersion, secureProperties);
        return new MuleArtifactJsonModel(muleApplicationModelJson);
    }

    public static MuleArtifactJsonModel buildMuleArtifactJson(Path muleArtifactJson) throws IOException {
        File muleArtifactJsonFile = muleArtifactJson.toFile();
        if (muleArtifactJsonFile.exists()) {
            String muleApplicationModelJson = Files.toString((File)muleArtifactJsonFile, (Charset)MULE_ARTIFACT_DEFAULT_CHARSET);
            return new MuleArtifactJsonModel(muleApplicationModelJson);
        }
        return MuleArtifactJsonModelUtils.buildMinimalMuleArtifactJson("4.1.1");
    }
}

