/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.pom;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Dependency {
    private final org.apache.maven.model.Dependency dependency;
    private static final String DEFAULT_TYPE = "jar";

    protected Dependency(org.apache.maven.model.Dependency dependency) {
        this.dependency = dependency;
    }

    protected org.apache.maven.model.Dependency getInnerModel() {
        return this.dependency;
    }

    protected Dependency() {
        this.dependency = new org.apache.maven.model.Dependency();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getGroupId(), that.getGroupId());
    }

    public int hashCode() {
        return Objects.hash(this.getArtifactId(), this.getGroupId());
    }

    public String getArtifactId() {
        return this.dependency.getArtifactId();
    }

    public String getGroupId() {
        return this.dependency.getGroupId();
    }

    public String getVersion() {
        return this.dependency.getVersion();
    }

    public String getClassifier() {
        return this.dependency.getClassifier();
    }

    public String getType() {
        return this.dependency.getType() != null ? this.dependency.getType() : DEFAULT_TYPE;
    }

    public String getScope() {
        return this.dependency.getScope();
    }

    public void setArtifactId(String artifactId) {
        this.dependency.setArtifactId(artifactId);
    }

    public void setGroupId(String groupId) {
        this.dependency.setGroupId(groupId);
    }

    public void setVersion(String version) {
        this.dependency.setVersion(version);
    }

    public void setClassifier(String classifier) {
        this.dependency.setClassifier(classifier);
    }

    public void setType(String type) {
        this.dependency.setType(type);
    }

    public void setScope(String scope) {
        this.dependency.setScope(scope);
    }

    public static class DependencyBuilder {
        private String artifactId;
        private String groupId;
        private String version;
        private String classifier;
        private String type;
        private String scope;

        public DependencyBuilder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public DependencyBuilder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public DependencyBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public DependencyBuilder withClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public DependencyBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public DependencyBuilder withScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Dependency build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.artifactId), (Object)"Artifact id cannot be null nor empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.groupId), (Object)"Group id cannot be null nor empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.version), (Object)"Version cannot be null nor empty");
            Dependency dependency = new Dependency();
            dependency.setArtifactId(this.artifactId);
            dependency.setGroupId(this.groupId);
            dependency.setVersion(this.version);
            if (this.classifier != null) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.classifier), (Object)"Classifier should not be blank");
                dependency.setClassifier(this.classifier);
            }
            if (this.type != null) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.type), (Object)"Type should not be blank");
                dependency.setType(this.type);
            }
            if (this.scope != null) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.scope), (Object)"Scope should not be blank");
                dependency.setScope(this.scope);
            }
            return dependency;
        }
    }
}

