/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.pom;

import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.project.model.pom.Parent;
import com.mulesoft.tools.migration.project.model.pom.Plugin;
import com.mulesoft.tools.migration.project.model.pom.PomModelUtils;
import com.mulesoft.tools.migration.project.model.pom.Repository;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PomModel {
    public static final String DEFAULT_GROUP_ID = "org.mule.migrated";
    public static final String DEFAULT_ARTIFACT_ID = "migrated-project";
    public static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    private final Model model;

    private PomModel(Model model) {
        this.model = model;
    }

    public PomModel() {
        this.model = new Model();
    }

    public List<Dependency> getDependencies() {
        return this.model.getDependencies().stream().map(Dependency::new).collect(Collectors.toList());
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.model.setDependencies(dependencies.stream().map(Dependency::getInnerModel).collect(Collectors.toList()));
    }

    public boolean addDependency(Dependency dependency) {
        block3: {
            block2: {
                if (dependency == null) break block2;
                if (!this.model.getDependencies().stream().map(Dependency::new).anyMatch(dependency::equals)) break block3;
            }
            return false;
        }
        this.model.addDependency(dependency.getInnerModel());
        return true;
    }

    public boolean removeDependency(Dependency dependency) {
        int originalNumDependencies = this.model.getDependencies().size();
        List dependencies = this.model.getDependencies().stream().filter(dep -> dep.getGroupId().equals(dependency.getGroupId()) && dep.getArtifactId().equals(dependency.getArtifactId())).collect(Collectors.toList());
        ArrayList newDeps = new ArrayList(this.model.getDependencies());
        newDeps.removeAll(dependencies);
        this.model.setDependencies(newDeps);
        return this.model.getDependencies().size() == originalNumDependencies - 1;
    }

    public String getPackaging() {
        return this.model.getPackaging();
    }

    public Model getMavenModelCopy() {
        return this.model.clone();
    }

    public void setPackaging(String packaging) {
        this.model.setPackaging(packaging);
    }

    public String getDescription() {
        return this.model.getDescription();
    }

    public void setDescription(String description) {
        this.model.setDescription(description);
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        this.model.setArtifactId(artifactId);
    }

    public Optional<Parent> getParent() {
        return Optional.ofNullable(this.model.getParent() != null ? new Parent(this.model.getParent()) : null);
    }

    public void setParent(Parent parent) {
        this.model.setParent(parent.getInnerModel());
    }

    public String getGroupId() {
        return this.model.getGroupId();
    }

    public void setGroupId(String groupId) {
        this.model.setGroupId(groupId);
    }

    public String getVersion() {
        return this.model.getVersion();
    }

    public void setVersion(String version) {
        this.model.setVersion(version);
    }

    public String getName() {
        return this.model.getName();
    }

    public void setName(String name) {
        this.model.setName(name);
    }

    public Properties getProperties() {
        return this.model.getProperties();
    }

    public void setProperties(Properties properties) {
        this.model.setProperties(properties);
    }

    public void addProperty(String key, String value) {
        this.model.addProperty(key, value);
    }

    public void removeProperty(String propertyName) {
        this.model.getProperties().remove(propertyName);
    }

    public void setModelVersion(String modelVersion) {
        this.model.setModelVersion(modelVersion);
    }

    public String getModelVersion() {
        return this.model.getModelVersion();
    }

    public void addPlugin(Plugin plugin) {
        this.getBuild().addPlugin(plugin.getInnerModel());
    }

    public List<Plugin> getPlugins() {
        return this.getBuild().getPlugins().stream().map(Plugin::new).collect(Collectors.toList());
    }

    public void removePlugin(Plugin plugin) {
        this.getBuild().removePlugin(plugin.getInnerModel());
    }

    public List<Plugin> removePlugins(Predicate<Plugin> pluginPredicate) {
        List<Plugin> removedPlugins = this.getPlugins().stream().filter(pluginPredicate).collect(Collectors.toList());
        removedPlugins.forEach(this::removePlugin);
        return removedPlugins;
    }

    public Optional<Plugin> removePlugin(Predicate<Plugin> pluginPredicate) {
        Optional<Plugin> removedPlugin = this.getPlugins().stream().filter(pluginPredicate).findFirst();
        removedPlugin.ifPresent(this::removePlugin);
        return removedPlugin;
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.model.setDistributionManagement(distributionManagement);
    }

    public DistributionManagement getDistributionManagement() {
        return this.model.getDistributionManagement();
    }

    public List<Profile> getProfiles() {
        return this.model.getProfiles();
    }

    private Build getBuild() {
        if (this.model.getBuild() == null) {
            this.model.setBuild(new Build());
        }
        return this.model.getBuild();
    }

    public List<Repository> getRepositories() {
        return this.model.getRepositories().stream().map(r -> Repository.of(r)).collect(Collectors.toList());
    }

    public void addRepository(Repository repository) {
        this.model.addRepository(repository.getInnerModel());
    }

    public void removeRepository(Repository repository) {
        this.model.removeRepository(repository.getInnerModel());
    }

    public List<Repository> getPluginRepositories() {
        return this.model.getPluginRepositories().stream().map(r -> Repository.of(r)).collect(Collectors.toList());
    }

    public void addPluginRepository(Repository repository) {
        this.model.addPluginRepository(repository.getInnerModel());
    }

    public static class PomModelBuilder {
        private final MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        private Path pomPath;
        private String groupId = "org.mule.migrated";
        private String artifactId = "migrated-project";
        private String version = "1.0.0-SNAPSHOT";
        private String packaging = "mule-application";

        public PomModelBuilder withPom(Path pomPath) {
            this.pomPath = pomPath;
            return this;
        }

        public PomModelBuilder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public PomModelBuilder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public PomModelBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public PomModelBuilder withPackaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        public PomModel build() throws IOException, XmlPullParserException {
            if (this.pomPath == null || !this.pomPath.toFile().exists()) {
                return PomModelUtils.buildMinimalMule4ApplicationPom(this.groupId, this.artifactId, this.version, this.packaging);
            }
            Model model = this.getModel(this.pomPath);
            return new PomModel(model);
        }

        private Model getModel(Path pomPath) throws IOException, XmlPullParserException {
            Model model;
            try (BufferedReader reader = new BufferedReader(new FileReader(pomPath.toFile()));){
                model = this.mavenReader.read((Reader)reader);
            }
            return model;
        }
    }
}

