/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.step;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractGlobalEndpointMigratorStep
extends AbstractApplicationModelMigrationStep {
    protected abstract Namespace getNamespace();

    protected final void doExecute(Element object, MigrationReport report) {
        List children = object.removeContent();
        for (Element referent : this.getRefs(object)) {
            this.changeNamespace(referent);
            AbstractGlobalEndpointMigratorStep.copyAttributes(object, referent);
            referent.addContent((Collection)children.stream().map(e -> e.clone()).collect(Collectors.toList()));
            referent.getAttribute("ref").setName("name");
        }
        for (Element referent : this.getInboundRefs(object)) {
            this.changeNamespace(referent);
            AbstractGlobalEndpointMigratorStep.copyAttributes(object, referent);
            referent.addContent((Collection)children.stream().map(e -> e.clone()).collect(Collectors.toList()));
            referent.getAttribute("ref").setName("name");
        }
        for (Element referent : this.getOutboundRefs(object)) {
            this.changeNamespace(referent);
            AbstractGlobalEndpointMigratorStep.copyAttributes(object, referent);
            referent.addContent((Collection)children.stream().map(e -> e.clone()).collect(Collectors.toList()));
            referent.getAttribute("ref").setName("name");
        }
        for (Element referent : this.getQuartzJobRefs(object)) {
            this.changeNamespace(referent);
            AbstractGlobalEndpointMigratorStep.copyAttributes(object, referent);
            referent.addContent((Collection)children.stream().map(e -> e.clone()).collect(Collectors.toList()));
            referent.getAttribute("ref").setName("name");
        }
        object.detach();
    }

    public static void copyAttributes(Element object, Element referent) {
        for (Attribute attribute : object.getAttributes()) {
            if (referent.getAttribute(attribute.getName(), attribute.getNamespace()) != null || "name".equals(attribute.getName()) || referent.getAttribute(attribute.getName()) != null) continue;
            referent.setAttribute(attribute.getName(), attribute.getValue(), attribute.getNamespace());
        }
    }

    protected Set<Element> getRefs(Element element) {
        HashSet<Element> refsToGlobal = new HashSet<Element>();
        refsToGlobal.addAll(this.getApplicationModel().getNodes("//" + this.getNamespace().getPrefix() + ":endpoint[@ref='" + element.getAttributeValue("name") + "']"));
        return refsToGlobal;
    }

    protected Set<Element> getInboundRefs(Element object) {
        HashSet<Element> inboundRefsToGlobal = new HashSet<Element>();
        inboundRefsToGlobal.addAll(this.getApplicationModel().getNodes("/*/mule:flow/mule:inbound-endpoint[@ref='" + object.getAttributeValue("name") + "']"));
        inboundRefsToGlobal.addAll(this.getApplicationModel().getNodes("/*/mule:flow/" + this.getNamespace().getPrefix() + ":inbound-endpoint[@ref='" + object.getAttributeValue("name") + "']"));
        return inboundRefsToGlobal;
    }

    protected Set<Element> getOutboundRefs(Element object) {
        HashSet<Element> outboundRefsToGlobal = new HashSet<Element>();
        outboundRefsToGlobal.addAll(this.getApplicationModel().getNodes("//mule:outbound-endpoint[@ref='" + object.getAttributeValue("name") + "']"));
        outboundRefsToGlobal.addAll(this.getApplicationModel().getNodes("//" + this.getNamespace().getPrefix() + ":outbound-endpoint[@ref='" + object.getAttributeValue("name") + "']"));
        return outboundRefsToGlobal;
    }

    protected Set<Element> getQuartzJobRefs(Element object) {
        HashSet<Element> quartzdRefsToGlobal = new HashSet<Element>();
        quartzdRefsToGlobal.addAll(this.getApplicationModel().getNodes("//quartz:job-endpoint[@ref='" + object.getAttributeValue("name") + "']"));
        return quartzdRefsToGlobal;
    }

    protected void changeNamespace(Element referent) {
        referent.setNamespace(this.getNamespace());
    }
}

