/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.util.version;

import com.google.common.base.Preconditions;
import com.mulesoft.tools.migration.exception.MigrationException;
import com.vdurmont.semver4j.Semver;
import de.skuzzle.semantic.Version;

public class VersionUtils {
    public static final String MIN_MULE4_VALID_VERSION = "4.1.1";

    public static Boolean isVersionValid(String version, String complyVersion) throws Exception {
        try {
            Preconditions.checkState((version != null ? 1 : 0) != 0, (Object)"The input version must not be null");
            return VersionUtils.isVersionGreaterOrEquals(version, complyVersion) != false && Version.isValidVersion((String)version);
        }
        catch (Exception e) {
            throw new MigrationException("Failed to continue executing migration: " + e.getMessage(), e);
        }
    }

    public static Boolean isVersionGreaterOrEquals(String version1, String version2) {
        String v1 = VersionUtils.completeIncremental(version1);
        Semver semver = new Semver(v1, Semver.SemverType.NPM);
        return semver.satisfies(version2) || semver.isGreaterThan(version2);
    }

    public static String completeIncremental(String version) {
        Semver semver = new Semver(version, Semver.SemverType.NPM);
        Integer minor = semver.getMinor();
        Integer patch = semver.getPatch();
        if (minor == null || patch == null) {
            version = Version.create((int)semver.getMajor(), (int)(minor == null ? 0 : minor), (int)(patch == null ? 0 : patch)).toString();
        }
        return VersionUtils.getBaseVersion(version);
    }

    public static String getBaseVersion(String version) {
        return new Semver(version).withClearedSuffixAndBuild().getValue();
    }
}

