/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.apikit.tasks.ApikitMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.BasicStructureMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.ClientIdEnforcementMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.FederationMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.HttpMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.IpFilterMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.MuleElementsMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.PolicyUtilsMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.ProxyMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.RamlProxyMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.ThreatProtectionMigrationTask;
import com.mulesoft.tools.migration.library.gateway.tasks.ThrottlingMigrationTask;
import com.mulesoft.tools.migration.library.mule.steps.compression.CompressionMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.AmqpMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.BatchMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.DbMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.DomainAppMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.EmailMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.EndpointsMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.ExpressionTransformerMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.FileMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.FiltersMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.FtpMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.HTTPCleanupTask;
import com.mulesoft.tools.migration.library.mule.tasks.HTTPMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.JmsDomainMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.JmsMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.JsonMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.MigrationCleanTask;
import com.mulesoft.tools.migration.library.mule.tasks.MuleCoreComponentsMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.MuleDeprecatedCoreComponentsMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.ObjectStoreMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.PostprocessGeneral;
import com.mulesoft.tools.migration.library.mule.tasks.PostprocessMuleApplication;
import com.mulesoft.tools.migration.library.mule.tasks.PreprocessMuleApplication;
import com.mulesoft.tools.migration.library.mule.tasks.PropertiesMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.QuartzMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.RequestReplyMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SalesforceMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.ScriptingMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SecurePropertiesMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SecurityCrc32MigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SecurityFiltersMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SecurityOAuth2ProviderMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SftpMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SocketsMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.SplitterAggregatorTask;
import com.mulesoft.tools.migration.library.mule.tasks.SpringMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.TransformersMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.VMMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.ValidationMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.VmDomainMigrationTask;
import com.mulesoft.tools.migration.library.mule.tasks.WscMigrationTask;
import com.mulesoft.tools.migration.library.munit.tasks.MunitMigrationTask;
import com.mulesoft.tools.migration.library.soapkit.tasks.SoapkitMigrationTask;
import com.mulesoft.tools.migration.task.AbstractMigrationTask;
import com.mulesoft.tools.migration.task.MigrationTask;
import com.mulesoft.tools.migration.util.version.VersionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MigrationTaskLocator {
    private final String from;
    private final String to;
    private final boolean noCompatibility;

    public MigrationTaskLocator(String from, String to) {
        this(from, to, false);
    }

    public MigrationTaskLocator(String from, String to, boolean noCompatibility) {
        Preconditions.checkArgument((from != null ? 1 : 0) != 0, (Object)"From must not be null");
        Preconditions.checkArgument((to != null ? 1 : 0) != 0, (Object)"To must not be null");
        this.from = from;
        this.to = to;
        this.noCompatibility = noCompatibility;
    }

    public List<AbstractMigrationTask> locate() {
        ArrayList migrationTasks = Lists.newArrayList(this.getPreMigrationTasks());
        migrationTasks.addAll(this.getCoreMigrationTasks());
        migrationTasks.addAll(this.getGatewayMigrationTasks());
        migrationTasks.addAll(this.getCoreAfterMigrationTasks());
        return migrationTasks.stream().filter(mt -> this.shouldNotFilterTask((MigrationTask)mt)).collect(Collectors.toList());
    }

    private Boolean shouldNotFilterTask(MigrationTask migrationTask) {
        if (!this.isProperlyCategorized(migrationTask).booleanValue()) {
            return Boolean.FALSE;
        }
        if (VersionUtils.isVersionGreaterOrEquals((String)migrationTask.getFrom(), (String)this.from).booleanValue() && VersionUtils.isVersionGreaterOrEquals((String)this.to, (String)migrationTask.getTo()).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean isProperlyCategorized(MigrationTask migrationTask) {
        if (migrationTask.getFrom() != null && migrationTask.getTo() != null && migrationTask.getProjectType() != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<AbstractMigrationTask> getPreMigrationTasks() {
        ArrayList<AbstractMigrationTask> coreMigrationTasks = new ArrayList<AbstractMigrationTask>();
        coreMigrationTasks.add((AbstractMigrationTask)new PreprocessMuleApplication());
        return coreMigrationTasks;
    }

    public List<AbstractMigrationTask> getCoreMigrationTasks() {
        ArrayList<AbstractMigrationTask> coreMigrationTasks = new ArrayList<AbstractMigrationTask>();
        coreMigrationTasks.add((AbstractMigrationTask)new SecurePropertiesMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SecurityCrc32MigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SecurityFiltersMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new PropertiesMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new MuleCoreComponentsMigrationTask(this.noCompatibility));
        coreMigrationTasks.add((AbstractMigrationTask)new SplitterAggregatorTask());
        coreMigrationTasks.add((AbstractMigrationTask)new BatchMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new ValidationMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new RequestReplyMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new QuartzMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new HTTPMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new EmailMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SocketsMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new WscMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new DbMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new ObjectStoreMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new FileMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new FtpMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SftpMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new EndpointsMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new JmsDomainMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new JmsMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new AmqpMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new VmDomainMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new VMMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new CompressionMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new ScriptingMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new JsonMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SecurityOAuth2ProviderMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SalesforceMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new DomainAppMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new MuleDeprecatedCoreComponentsMigrationTask(this.noCompatibility));
        coreMigrationTasks.add((AbstractMigrationTask)new MunitMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new TransformersMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new ExpressionTransformerMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new ApikitMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SoapkitMigrationTask());
        return coreMigrationTasks;
    }

    public List<AbstractMigrationTask> getCoreAfterMigrationTasks() {
        ArrayList<AbstractMigrationTask> coreMigrationTasks = new ArrayList<AbstractMigrationTask>();
        coreMigrationTasks.add((AbstractMigrationTask)new FiltersMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new SpringMigrationTask());
        coreMigrationTasks.add((AbstractMigrationTask)new HTTPCleanupTask());
        coreMigrationTasks.add((AbstractMigrationTask)new MigrationCleanTask());
        coreMigrationTasks.add((AbstractMigrationTask)new PostprocessGeneral());
        if (!this.noCompatibility) {
            coreMigrationTasks.add((AbstractMigrationTask)new PostprocessMuleApplication());
        }
        return coreMigrationTasks;
    }

    protected List<AbstractMigrationTask> getGatewayMigrationTasks() {
        ArrayList<AbstractMigrationTask> gatewayMigrationTasks = new ArrayList<AbstractMigrationTask>();
        gatewayMigrationTasks.add((AbstractMigrationTask)new ProxyMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new RamlProxyMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new IpFilterMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new ThreatProtectionMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new ThrottlingMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new ClientIdEnforcementMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new FederationMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new HttpMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new MuleElementsMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new PolicyUtilsMigrationTask());
        gatewayMigrationTasks.add((AbstractMigrationTask)new BasicStructureMigrationTask());
        return gatewayMigrationTasks;
    }
}

