/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine.project.structure.mule.three;

import com.mulesoft.tools.migration.engine.project.structure.mule.MuleProject;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleThreePolicy
extends MuleProject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleThreePolicy.class);

    public static boolean isPolicyInFolder(Path projectPath) {
        return Arrays.stream(projectPath.toFile().listFiles((FilenameFilter)new SuffixFileFilter(".yaml"))).anyMatch(yaml -> Arrays.stream(projectPath.toFile().listFiles((FilenameFilter)new SuffixFileFilter(".xml"))).anyMatch(policyXml -> {
            Element xmlRootElement;
            try {
                xmlRootElement = XmlDslUtils.generateDocument((Path)policyXml.toPath(), (boolean)false).getRootElement();
            }
            catch (IOException | JDOMException e) {
                LOGGER.warn(e.getClass().getName() + ": " + e.getMessage());
                return false;
            }
            return "policy".equals(xmlRootElement.getName()) && "http://www.mulesoft.org/schema/mule/policy".equals(xmlRootElement.getNamespaceURI());
        }));
    }

    public MuleThreePolicy(Path baseFolder) {
        super(baseFolder);
    }

    @Override
    public Path srcMainConfiguration() {
        return this.baseFolder.resolve(".");
    }

    @Override
    public Path srcTestConfiguration() {
        return this.baseFolder.resolve("./test");
    }
}

