/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.schema;

import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.compiler.schema.CloningVisitor;
import org.apache.avro.compiler.schema.SchemaVisitor;
import org.apache.avro.compiler.schema.SchemaVisitorAction;
import org.apache.avro.compiler.schema.Schemas;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemas {
    private static final String SCHEMA = "{\"type\":\"record\",\"name\":\"SampleNode\",\"doc\":\"caca\",\"namespace\":\"org.spf4j.ssdump2.avro\",\n \"fields\":[\n    {\"name\":\"count\",\"type\":\"int\",\"default\":0,\"doc\":\"caca\"},\n    {\"name\":\"kind1\",\"type\":{\"type\":\"enum\", \"name\": \"Kind1\", \"symbols\": [\"A1\", \"B1\"]}},\n    {\"name\":\"kind2\",\"type\":{\"type\":\"enum\", \"name\": \"Kind2\", \"symbols\": [\"A2\", \"B2\"], \"doc\": \"doc\"}},\n    {\"name\":\"pat\",\"type\":{\"type\":\"fixed\", \"name\": \"FixedPattern\", \"size\": 10}},\n    {\"name\":\"uni\",\"type\":[\"int\", \"double\"]},\n    {\"name\":\"mp\",\"type\":{\"type\":\"map\", \"values\": \"int\"}},\n    {\"name\":\"subNodes\",\"type\":\n       {\"type\":\"array\",\"items\":{\n           \"type\":\"record\",\"name\":\"SamplePair\",\n           \"fields\":[\n              {\"name\":\"method\",\"type\":\n                  {\"type\":\"record\",\"name\":\"Method\",\n                  \"fields\":[\n                     {\"name\":\"declaringClass\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\n                     {\"name\":\"methodName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}\n                  ]}},\n              {\"name\":\"node\",\"type\":\"SampleNode\"}]}}}]}";

    @Test
    public void textCloning() {
        Schema recSchema = new Schema.Parser().parse(SCHEMA);
        Schemas.visit((Schema)recSchema, (SchemaVisitor)new PrintingVisitor());
        CloningVisitor cv = new CloningVisitor(recSchema);
        Schema trimmed = (Schema)Schemas.visit((Schema)recSchema, (SchemaVisitor)cv);
        Assert.assertNull((Object)trimmed.getDoc());
        Assert.assertNotNull((Object)recSchema.getDoc());
        SchemaCompatibility.SchemaCompatibilityType compat = SchemaCompatibility.checkReaderWriterCompatibility((Schema)trimmed, (Schema)recSchema).getType();
        Assert.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, (Object)compat);
        compat = SchemaCompatibility.checkReaderWriterCompatibility((Schema)recSchema, (Schema)trimmed).getType();
        Assert.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, (Object)compat);
        Assert.assertNotNull((Object)cv.toString());
    }

    @Test
    public void textCloningCopyDocs() {
        Schema recSchema = new Schema.Parser().parse(SCHEMA);
        Schemas.visit((Schema)recSchema, (SchemaVisitor)new PrintingVisitor());
        Schema trimmed = (Schema)Schemas.visit((Schema)recSchema, (SchemaVisitor)new CloningVisitor(new CloningVisitor.PropertyCopier(){

            public void copy(Schema first, Schema second) {
                Schemas.copyLogicalTypes((Schema)first, (Schema)second);
                Schemas.copyAliases((Schema)first, (Schema)second);
            }

            public void copy(Schema.Field first, Schema.Field second) {
                Schemas.copyAliases((Schema.Field)first, (Schema.Field)second);
            }
        }, true, recSchema));
        Assert.assertEquals((Object)"caca", (Object)trimmed.getDoc());
        Assert.assertNotNull((Object)recSchema.getDoc());
        SchemaCompatibility.SchemaCompatibilityType compat = SchemaCompatibility.checkReaderWriterCompatibility((Schema)trimmed, (Schema)recSchema).getType();
        Assert.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, (Object)compat);
        compat = SchemaCompatibility.checkReaderWriterCompatibility((Schema)recSchema, (Schema)trimmed).getType();
        Assert.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, (Object)compat);
    }

    @Test(expected=IllegalStateException.class)
    public void testCloningError1() {
        Schema recordSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"R\", \"fields\":[{\"name\": \"f1\", \"type\": [\"int\", \"long\"]}]}");
        new CloningVisitor(recordSchema).visitTerminal(recordSchema.getField("f1").schema());
    }

    @Test(expected=IllegalStateException.class)
    public void testCloningError2() {
        Schema recordSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"R\", \"fields\":[{\"name\": \"f1\", \"type\": \"int\"}]}");
        new CloningVisitor(recordSchema).afterVisitNonTerminal(recordSchema.getField("f1").schema());
    }

    @Test
    public void testHasGeneratedJavaClass() {
        Assert.assertTrue((boolean)Schemas.hasGeneratedJavaClass((Schema)new Schema.Parser().parse("{\"type\": \"fixed\", \"name\": \"N\", \"size\": 10}")));
        Assert.assertFalse((boolean)Schemas.hasGeneratedJavaClass((Schema)new Schema.Parser().parse("{\"type\": \"int\"}")));
    }

    @Test
    public void testGetJavaClassName() {
        Assert.assertEquals((Object)"N", (Object)Schemas.getJavaClassName((Schema)new Schema.Parser().parse("{\"type\": \"fixed\", \"name\": \"N\", \"size\": 10}")));
        Assert.assertEquals((Object)"N", (Object)Schemas.getJavaClassName((Schema)new Schema.Parser().parse("{\"type\": \"fixed\", \"name\": \"N\", \"size\": 10, \"namespace\": \"\"}")));
        Assert.assertEquals((Object)"com.example.N", (Object)Schemas.getJavaClassName((Schema)new Schema.Parser().parse("{\"type\": \"fixed\", \"name\": \"N\", \"size\": 10, \"namespace\": \"com.example\"}")));
    }

    @Test
    public void testVisit1() {
        String s1 = "{\"type\": \"record\", \"name\": \"t1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"t1.", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s1), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit2() {
        String s2 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"c1.\"int\"!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s2), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit3() {
        String s3 = "{\"type\": \"record\", \"name\": \"ss1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"ss1.", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s3), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit4() {
        String s4 = "{\"type\": \"record\", \"name\": \"st1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"st1.!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s4), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit5() {
        String s5 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"c2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.c2.\"int\"!\"long\"!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s5), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit6() {
        String s6 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ss2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.ss2.!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s6), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit7() {
        String s7 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"css2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.css2.\"int\"!!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s7), (SchemaVisitor)new TestVisitor()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testVisit8() {
        String s8 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"cst2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"int\"}]}";
        Schemas.visit((Schema)new Schema.Parser().parse(s8), (SchemaVisitor)new TestVisitor());
    }

    @Test
    public void testVisit9() {
        String s9 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ct2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.ct2.\"int\"!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s9), (SchemaVisitor)new TestVisitor()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testVisit10() {
        String s10 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ct2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"int\"}]}";
        Schemas.visit((Schema)new Schema.Parser().parse(s10), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitorAction visitTerminal(Schema terminal) {
                return SchemaVisitorAction.SKIP_SUBTREE;
            }
        });
    }

    @Test
    public void testVisit11() {
        String s11 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"c2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"},{\"name\": \"f12\", \"type\": \"double\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.c2.\"int\".!\"long\".!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s11), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitorAction visitTerminal(Schema terminal) {
                this.sb.append(terminal).append('.');
                return SchemaVisitorAction.SKIP_SIBLINGS;
            }
        }));
    }

    @Test
    public void testVisit12() {
        String s12 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ct2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.ct2.\"int\".", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s12), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitorAction visitTerminal(Schema terminal) {
                this.sb.append(terminal).append('.');
                return SchemaVisitorAction.TERMINATE;
            }
        }));
    }

    @Test
    public void testVisit13() {
        String s12 = "{\"type\": \"int\"}";
        Assert.assertEquals((Object)"\"int\".", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s12), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitorAction visitTerminal(Schema terminal) {
                this.sb.append(terminal).append('.');
                return SchemaVisitorAction.SKIP_SIBLINGS;
            }
        }));
    }

    private static class TestVisitor
    implements SchemaVisitor<String> {
        StringBuilder sb = new StringBuilder();

        private TestVisitor() {
        }

        public SchemaVisitorAction visitTerminal(Schema terminal) {
            this.sb.append(terminal);
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction visitNonTerminal(Schema nonTerminal) {
            String n = nonTerminal.getName();
            this.sb.append(n).append('.');
            if (n.startsWith("t")) {
                return SchemaVisitorAction.TERMINATE;
            }
            if (n.startsWith("ss")) {
                return SchemaVisitorAction.SKIP_SIBLINGS;
            }
            if (n.startsWith("st")) {
                return SchemaVisitorAction.SKIP_SUBTREE;
            }
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction afterVisitNonTerminal(Schema nonTerminal) {
            this.sb.append("!");
            String n = nonTerminal.getName();
            if (n.startsWith("ct")) {
                return SchemaVisitorAction.TERMINATE;
            }
            if (n.startsWith("css")) {
                return SchemaVisitorAction.SKIP_SIBLINGS;
            }
            if (n.startsWith("cst")) {
                return SchemaVisitorAction.SKIP_SUBTREE;
            }
            return SchemaVisitorAction.CONTINUE;
        }

        public String get() {
            return this.sb.toString();
        }
    }

    private static class PrintingVisitor
    implements SchemaVisitor {
        private PrintingVisitor() {
        }

        public SchemaVisitorAction visitTerminal(Schema terminal) {
            System.out.println("Terminal: " + terminal.getFullName());
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction visitNonTerminal(Schema terminal) {
            System.out.println("NONTerminal start: " + terminal.getFullName());
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction afterVisitNonTerminal(Schema terminal) {
            System.out.println("NONTerminal end: " + terminal.getFullName());
            return SchemaVisitorAction.CONTINUE;
        }

        public Object get() {
            return null;
        }
    }
}

