/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestSpecificCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificCompiler.class);
    @Rule
    public TemporaryFolder OUTPUT_DIR = new TemporaryFolder();
    @Rule
    public TestName name = new TestName();
    private File outputFile;
    private File src = new File("src/test/resources/simple_record.avsc");

    @Before
    public void setUp() {
        this.outputFile = new File(this.OUTPUT_DIR.getRoot(), "SimpleRecord.java");
    }

    static void assertCompilesWithJavaCompiler(File dstDir, Collection<SpecificCompiler.OutputFile> outputs) throws IOException {
        TestSpecificCompiler.assertCompilesWithJavaCompiler(dstDir, outputs, false);
    }

    static void assertCompilesWithJavaCompiler(File dstDir, Collection<SpecificCompiler.OutputFile> outputs, boolean ignoreWarnings) throws IOException {
        if (outputs.isEmpty()) {
            return;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<File> javaFiles = new ArrayList<File>();
        for (SpecificCompiler.OutputFile o : outputs) {
            javaFiles.add(o.writeToDestination(null, dstDir));
        }
        ArrayList warnings = new ArrayList();
        DiagnosticListener diagnosticListener = diagnostic -> {
            switch (diagnostic.getKind()) {
                case ERROR: {
                    LOG.error("{}", (Object)diagnostic);
                    break;
                }
                case WARNING: 
                case MANDATORY_WARNING: {
                    LOG.warn("{}", (Object)diagnostic);
                    warnings.add(diagnostic);
                    break;
                }
                case NOTE: 
                case OTHER: {
                    LOG.debug("{}", (Object)diagnostic);
                }
            }
        };
        JavaCompiler.CompilationTask cTask = compiler.getTask(null, fileManager, diagnosticListener, Collections.singletonList("-Xlint:all"), null, fileManager.getJavaFileObjects(javaFiles.toArray(new File[0])));
        boolean compilesWithoutError = cTask.call();
        Assert.assertTrue((boolean)compilesWithoutError);
        if (!ignoreWarnings) {
            Assert.assertEquals((String)"Warnings produced when compiling generated code with -Xlint:all", (long)0L, (long)warnings.size());
        }
    }

    private static Schema createSampleRecordSchema(int numStringFields, int numDoubleFields) {
        int i;
        SchemaBuilder.FieldAssembler sb = SchemaBuilder.record((String)"sample.record").fields();
        for (i = 0; i < numStringFields; ++i) {
            sb.name("sf_" + i).type().stringType().noDefault();
        }
        for (i = 0; i < numDoubleFields; ++i) {
            sb.name("df_" + i).type().doubleType().noDefault();
        }
        return (Schema)sb.endRecord();
    }

    private SpecificCompiler createCompiler() throws IOException {
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(this.src);
        SpecificCompiler compiler = new SpecificCompiler(schema);
        String velocityTemplateDir = "src/main/velocity/org/apache/avro/compiler/specific/templates/java/classic/";
        compiler.setTemplateDir(velocityTemplateDir);
        compiler.setStringType(GenericData.StringType.CharSequence);
        return compiler;
    }

    @Test
    public void testCanReadTemplateFilesOnTheFilesystem() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)new File(this.OUTPUT_DIR.getRoot(), "SimpleRecord.java").exists());
    }

    @Test
    public void testPublicFieldVisibility() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.PUBLIC);
        Assert.assertFalse((boolean)compiler.deprecatedFields());
        Assert.assertTrue((boolean)compiler.publicFields());
        Assert.assertFalse((boolean)compiler.privateFields());
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                Assert.assertFalse((String)("Line started with a deprecated field declaration: " + line), (boolean)line.startsWith("@Deprecated public int value"));
            }
        }
    }

    @Test
    public void testCreateAllArgsConstructor() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        boolean foundAllArgsConstructor = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while (!foundAllArgsConstructor && (line = reader.readLine()) != null) {
                foundAllArgsConstructor = line.contains("All-args constructor");
            }
        }
        Assert.assertTrue((boolean)foundAllArgsConstructor);
    }

    @Test
    public void testMaxValidParameterCounts() throws Exception {
        Schema validSchema1 = TestSpecificCompiler.createSampleRecordSchema(254, 0);
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.OUTPUT_DIR.getRoot(), this.name.getMethodName() + "1"), new SpecificCompiler(validSchema1).compile());
        Schema validSchema2 = TestSpecificCompiler.createSampleRecordSchema(252, 1);
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.OUTPUT_DIR.getRoot(), this.name.getMethodName() + "2"), new SpecificCompiler(validSchema1).compile());
    }

    @Test
    public void testInvalidParameterCounts() throws Exception {
        Schema invalidSchema1 = TestSpecificCompiler.createSampleRecordSchema(255, 0);
        SpecificCompiler compiler = new SpecificCompiler(invalidSchema1);
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.OUTPUT_DIR.getRoot(), this.name.getMethodName() + "1"), compiler.compile());
        Schema invalidSchema2 = TestSpecificCompiler.createSampleRecordSchema(254, 10);
        compiler = new SpecificCompiler(invalidSchema2);
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.OUTPUT_DIR.getRoot(), this.name.getMethodName() + "2"), compiler.compile());
    }

    @Test
    public void testMaxParameterCounts() throws Exception {
        Schema validSchema1 = TestSpecificCompiler.createSampleRecordSchema(254, 0);
        Assert.assertTrue((new SpecificCompiler(validSchema1).compile().size() > 0 ? 1 : 0) != 0);
        Schema validSchema2 = TestSpecificCompiler.createSampleRecordSchema(252, 1);
        Assert.assertTrue((new SpecificCompiler(validSchema2).compile().size() > 0 ? 1 : 0) != 0);
        Schema validSchema3 = TestSpecificCompiler.createSampleRecordSchema(253, 1);
        Assert.assertTrue((new SpecificCompiler(validSchema3).compile().size() > 0 ? 1 : 0) != 0);
        Schema validSchema4 = TestSpecificCompiler.createSampleRecordSchema(255, 0);
        Assert.assertTrue((new SpecificCompiler(validSchema4).compile().size() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void testCalcAllArgConstructorParameterUnitsFailure() {
        Schema nonRecordSchema = (Schema)SchemaBuilder.array().items().booleanType();
        new SpecificCompiler().calcAllArgConstructorParameterUnits(nonRecordSchema);
    }

    @Test
    public void testPublicDeprecatedFieldVisibility() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.PUBLIC_DEPRECATED);
        Assert.assertTrue((boolean)compiler.deprecatedFields());
        Assert.assertTrue((boolean)compiler.publicFields());
        Assert.assertFalse((boolean)compiler.privateFields());
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                Assert.assertFalse((String)("Line started with a public field declaration: " + line), (boolean)line.startsWith("public int value"));
            }
        }
    }

    @Test
    public void testPrivateFieldVisibility() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.PRIVATE);
        Assert.assertFalse((boolean)compiler.deprecatedFields());
        Assert.assertFalse((boolean)compiler.publicFields());
        Assert.assertTrue((boolean)compiler.privateFields());
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                Assert.assertFalse((String)("Line started with a public field declaration: " + line), (boolean)line.startsWith("public int value"));
                Assert.assertFalse((String)("Line started with a deprecated field declaration: " + line), (boolean)line.startsWith("@Deprecated public int value"));
            }
        }
    }

    @Test
    public void testSettersCreatedByDefault() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        Assert.assertTrue((boolean)compiler.isCreateSetters());
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        int foundSetters = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("public void setValue(")) continue;
                ++foundSetters;
            }
        }
        Assert.assertEquals((String)"Found the wrong number of setters", (long)1L, (long)foundSetters);
    }

    @Test
    public void testSettersNotCreatedWhenOptionTurnedOff() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setCreateSetters(false);
        Assert.assertFalse((boolean)compiler.isCreateSetters());
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                Assert.assertFalse((String)("No line should include the setter: " + line), (boolean)line.startsWith("public void setValue("));
            }
        }
    }

    @Test
    public void testSettingOutputCharacterEncoding() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        byte[] fileInDefaultEncoding = new byte[(int)this.outputFile.length()];
        FileInputStream is = new FileInputStream(this.outputFile);
        is.read(fileInDefaultEncoding);
        is.close();
        if (!this.outputFile.delete()) {
            throw new IllegalStateException("unable to delete " + this.outputFile);
        }
        String differentEncoding = Charset.defaultCharset().equals(Charset.forName("UTF-16")) ? "UTF-32" : "UTF-16";
        compiler.setOutputCharacterEncoding(differentEncoding);
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        byte[] fileInDifferentEncoding = new byte[(int)this.outputFile.length()];
        is = new FileInputStream(this.outputFile);
        is.read(fileInDifferentEncoding);
        is.close();
        Assert.assertThat((String)"Generated file should contain different bytes after setting non-default encoding", (Object)fileInDefaultEncoding, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)fileInDifferentEncoding)));
        Assert.assertThat((String)"Generated files should contain the same characters in the proper encodings", (Object)new String(fileInDefaultEncoding), (Matcher)CoreMatchers.equalTo((Object)new String(fileInDifferentEncoding, differentEncoding)));
    }

    @Test
    public void testJavaTypeWithDecimalLogicalTypeEnabled() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(true);
        Schema dateSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeSchema = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timestampSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema decimalSchema = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema uuidSchema = LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        Assert.assertEquals((String)"Should use LocalDate for date type", (Object)"java.time.LocalDate", (Object)compiler.javaType(dateSchema));
        Assert.assertEquals((String)"Should use LocalTime for time-millis type", (Object)"java.time.LocalTime", (Object)compiler.javaType(timeSchema));
        Assert.assertEquals((String)"Should use DateTime for timestamp-millis type", (Object)"java.time.Instant", (Object)compiler.javaType(timestampSchema));
        Assert.assertEquals((String)"Should use Java BigDecimal type", (Object)"java.math.BigDecimal", (Object)compiler.javaType(decimalSchema));
        Assert.assertEquals((String)"Should use Java CharSequence type", (Object)"java.lang.CharSequence", (Object)compiler.javaType(uuidSchema));
    }

    @Test
    public void testJavaTypeWithDecimalLogicalTypeDisabled() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(false);
        Schema dateSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeSchema = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timestampSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema decimalSchema = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema uuidSchema = LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        Assert.assertEquals((String)"Should use LocalDate for date type", (Object)"java.time.LocalDate", (Object)compiler.javaType(dateSchema));
        Assert.assertEquals((String)"Should use LocalTime for time-millis type", (Object)"java.time.LocalTime", (Object)compiler.javaType(timeSchema));
        Assert.assertEquals((String)"Should use DateTime for timestamp-millis type", (Object)"java.time.Instant", (Object)compiler.javaType(timestampSchema));
        Assert.assertEquals((String)"Should use ByteBuffer type", (Object)"java.nio.ByteBuffer", (Object)compiler.javaType(decimalSchema));
        Assert.assertEquals((String)"Should use Java CharSequence type", (Object)"java.lang.CharSequence", (Object)compiler.javaType(uuidSchema));
    }

    @Test
    public void testJavaTypeWithDateTimeTypes() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        Schema dateSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeSchema = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeMicrosSchema = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema timestampSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema timestampMicrosSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Assert.assertEquals((String)"Should use java.time.LocalDate for date type", (Object)"java.time.LocalDate", (Object)compiler.javaType(dateSchema));
        Assert.assertEquals((String)"Should use java.time.LocalTime for time-millis type", (Object)"java.time.LocalTime", (Object)compiler.javaType(timeSchema));
        Assert.assertEquals((String)"Should use java.time.Instant for timestamp-millis type", (Object)"java.time.Instant", (Object)compiler.javaType(timestampSchema));
        Assert.assertEquals((String)"Should use java.time.LocalTime for time-micros type", (Object)"java.time.LocalTime", (Object)compiler.javaType(timeMicrosSchema));
        Assert.assertEquals((String)"Should use java.time.Instant for timestamp-micros type", (Object)"java.time.Instant", (Object)compiler.javaType(timestampMicrosSchema));
    }

    @Test
    public void testJavaUnbox() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(false);
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema floatSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
        Schema doubleSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        Schema boolSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        Assert.assertEquals((String)"Should use int for Type.INT", (Object)"int", (Object)compiler.javaUnbox(intSchema));
        Assert.assertEquals((String)"Should use long for Type.LONG", (Object)"long", (Object)compiler.javaUnbox(longSchema));
        Assert.assertEquals((String)"Should use float for Type.FLOAT", (Object)"float", (Object)compiler.javaUnbox(floatSchema));
        Assert.assertEquals((String)"Should use double for Type.DOUBLE", (Object)"double", (Object)compiler.javaUnbox(doubleSchema));
        Assert.assertEquals((String)"Should use boolean for Type.BOOLEAN", (Object)"boolean", (Object)compiler.javaUnbox(boolSchema));
        Schema dateSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeSchema = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timestampSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Assert.assertEquals((String)"Should use LocalDate for date type", (Object)"java.time.LocalDate", (Object)compiler.javaUnbox(dateSchema));
        Assert.assertEquals((String)"Should use LocalTime for time-millis type", (Object)"java.time.LocalTime", (Object)compiler.javaUnbox(timeSchema));
        Assert.assertEquals((String)"Should use DateTime for timestamp-millis type", (Object)"java.time.Instant", (Object)compiler.javaUnbox(timestampSchema));
    }

    @Test
    public void testJavaUnboxDateTime() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        Schema dateSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeSchema = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timestampSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Assert.assertEquals((String)"Should use java.time.LocalDate for date type", (Object)"java.time.LocalDate", (Object)compiler.javaUnbox(dateSchema));
        Assert.assertEquals((String)"Should use java.time.LocalTime for time-millis type", (Object)"java.time.LocalTime", (Object)compiler.javaUnbox(timeSchema));
        Assert.assertEquals((String)"Should use java.time.Instant for timestamp-millis type", (Object)"java.time.Instant", (Object)compiler.javaUnbox(timestampSchema));
    }

    @Test
    public void testNullableLogicalTypesJavaUnboxDecimalTypesEnabled() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(true);
        Schema nullableDecimalSchema1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES))});
        Schema nullableDecimalSchema2 = Schema.createUnion((Schema[])new Schema[]{LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)), Schema.create((Schema.Type)Schema.Type.NULL)});
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableDecimalSchema1), (Object)"java.math.BigDecimal");
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableDecimalSchema2), (Object)"java.math.BigDecimal");
    }

    @Test
    public void testNullableLogicalTypesJavaUnboxDecimalTypesDisabled() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(false);
        Schema nullableDecimalSchema1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES))});
        Schema nullableDecimalSchema2 = Schema.createUnion((Schema[])new Schema[]{LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)), Schema.create((Schema.Type)Schema.Type.NULL)});
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableDecimalSchema1), (Object)"java.nio.ByteBuffer");
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableDecimalSchema2), (Object)"java.nio.ByteBuffer");
    }

    @Test
    public void testNullableTypesJavaUnbox() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(false);
        Schema nullableIntSchema1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.INT)});
        Schema nullableIntSchema2 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.NULL)});
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableIntSchema1), (Object)"java.lang.Integer");
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableIntSchema2), (Object)"java.lang.Integer");
        Schema nullableLongSchema1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)});
        Schema nullableLongSchema2 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.NULL)});
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableLongSchema1), (Object)"java.lang.Long");
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableLongSchema2), (Object)"java.lang.Long");
        Schema nullableFloatSchema1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.FLOAT)});
        Schema nullableFloatSchema2 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.FLOAT), Schema.create((Schema.Type)Schema.Type.NULL)});
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableFloatSchema1), (Object)"java.lang.Float");
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableFloatSchema2), (Object)"java.lang.Float");
        Schema nullableDoubleSchema1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.DOUBLE)});
        Schema nullableDoubleSchema2 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.NULL)});
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableDoubleSchema1), (Object)"java.lang.Double");
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableDoubleSchema2), (Object)"java.lang.Double");
        Schema nullableBooleanSchema1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BOOLEAN)});
        Schema nullableBooleanSchema2 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.NULL)});
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableBooleanSchema1), (Object)"java.lang.Boolean");
        Assert.assertEquals((String)"Should return boxed type", (Object)compiler.javaUnbox(nullableBooleanSchema2), (Object)"java.lang.Boolean");
    }

    @Test
    public void testGetUsedConversionClassesForNullableLogicalTypes() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(true);
        Schema nullableDecimal1 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES))});
        Schema schemaWithNullableDecimal1 = Schema.createRecord((String)"WithNullableDecimal", (String)"", (String)"", (boolean)false, Collections.singletonList(new Schema.Field("decimal", nullableDecimal1, "", null)));
        Collection usedConversionClasses = compiler.getUsedConversionClasses(schemaWithNullableDecimal1);
        Assert.assertEquals((long)1L, (long)usedConversionClasses.size());
        Assert.assertEquals((Object)"org.apache.avro.Conversions.DecimalConversion", usedConversionClasses.iterator().next());
    }

    @Test
    public void testGetUsedConversionClassesForNullableLogicalTypesInNestedRecord() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NestedLogicalTypesRecord\",\"namespace\":\"org.apache.avro.codegentest.testdata\",\"doc\":\"Test nested types with logical types in generated Java classes\",\"fields\":[{\"name\":\"nestedRecord\",\"type\":{\"type\":\"record\",\"name\":\"NestedRecord\",\"fields\":[{\"name\":\"nullableDateField\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}]}]}}]}");
        Collection usedConversionClasses = compiler.getUsedConversionClasses(schema);
        Assert.assertEquals((long)1L, (long)usedConversionClasses.size());
        Assert.assertEquals((Object)"org.apache.avro.data.TimeConversions.DateConversion", usedConversionClasses.iterator().next());
    }

    @Test
    public void testGetUsedConversionClassesForNullableLogicalTypesInArray() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NullableLogicalTypesArray\",\"namespace\":\"org.apache.avro.codegentest.testdata\",\"doc\":\"Test nested types with logical types in generated Java classes\",\"fields\":[{\"name\":\"arrayOfLogicalType\",\"type\":{\"type\":\"array\",\"items\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}]}}]}");
        Collection usedConversionClasses = compiler.getUsedConversionClasses(schema);
        Assert.assertEquals((long)1L, (long)usedConversionClasses.size());
        Assert.assertEquals((Object)"org.apache.avro.data.TimeConversions.DateConversion", usedConversionClasses.iterator().next());
    }

    @Test
    public void testGetUsedConversionClassesForNullableLogicalTypesInArrayOfRecords() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NestedLogicalTypesArray\",\"namespace\":\"org.apache.avro.codegentest.testdata\",\"doc\":\"Test nested types with logical types in generated Java classes\",\"fields\":[{\"name\":\"arrayOfRecords\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"RecordInArray\",\"fields\":[{\"name\":\"nullableDateField\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}]}]}}}]}");
        Collection usedConversionClasses = compiler.getUsedConversionClasses(schema);
        Assert.assertEquals((long)1L, (long)usedConversionClasses.size());
        Assert.assertEquals((Object)"org.apache.avro.data.TimeConversions.DateConversion", usedConversionClasses.iterator().next());
    }

    @Test
    public void testGetUsedConversionClassesForNullableLogicalTypesInUnionOfRecords() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NestedLogicalTypesUnion\",\"namespace\":\"org.apache.avro.codegentest.testdata\",\"doc\":\"Test nested types with logical types in generated Java classes\",\"fields\":[{\"name\":\"unionOfRecords\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"RecordInUnion\",\"fields\":[{\"name\":\"nullableDateField\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}]}]}]}]}");
        Collection usedConversionClasses = compiler.getUsedConversionClasses(schema);
        Assert.assertEquals((long)1L, (long)usedConversionClasses.size());
        Assert.assertEquals((Object)"org.apache.avro.data.TimeConversions.DateConversion", usedConversionClasses.iterator().next());
    }

    @Test
    public void testGetUsedConversionClassesForNullableLogicalTypesInMapOfRecords() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NestedLogicalTypesMap\",\"namespace\":\"org.apache.avro.codegentest.testdata\",\"doc\":\"Test nested types with logical types in generated Java classes\",\"fields\":[{\"name\":\"mapOfRecords\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"RecordInMap\",\"fields\":[{\"name\":\"nullableDateField\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}]}]},\"avro.java.string\":\"String\"}}]}");
        Collection usedConversionClasses = compiler.getUsedConversionClasses(schema);
        Assert.assertEquals((long)1L, (long)usedConversionClasses.size());
        Assert.assertEquals((Object)"org.apache.avro.data.TimeConversions.DateConversion", usedConversionClasses.iterator().next());
    }

    @Test
    public void testLogicalTypesWithMultipleFields() throws Exception {
        Schema logicalTypesWithMultipleFields = new Schema.Parser().parse(new File("src/test/resources/logical_types_with_multiple_fields.avsc"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.OUTPUT_DIR.getRoot(), this.name.getMethodName()), new SpecificCompiler(logicalTypesWithMultipleFields).compile(), true);
    }

    @Test
    public void testUnionAndFixedFields() throws Exception {
        Schema unionTypesWithMultipleFields = new Schema.Parser().parse(new File("src/test/resources/union_and_fixed_fields.avsc"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.outputFile, this.name.getMethodName()), new SpecificCompiler(unionTypesWithMultipleFields).compile());
    }

    @Test
    public void testLogicalTypesWithMultipleFieldsDateTime() throws Exception {
        Schema logicalTypesWithMultipleFields = new Schema.Parser().parse(new File("src/test/resources/logical_types_with_multiple_fields.avsc"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(new File(this.outputFile, this.name.getMethodName()), new SpecificCompiler(logicalTypesWithMultipleFields).compile());
    }

    @Test
    public void testConversionInstanceWithDecimalLogicalTypeDisabled() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(false);
        Schema dateSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeSchema = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timestampSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema decimalSchema = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema uuidSchema = LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        Assert.assertEquals((String)"Should use date conversion for date type", (Object)"new org.apache.avro.data.TimeConversions.DateConversion()", (Object)compiler.conversionInstance(dateSchema));
        Assert.assertEquals((String)"Should use time conversion for time type", (Object)"new org.apache.avro.data.TimeConversions.TimeMillisConversion()", (Object)compiler.conversionInstance(timeSchema));
        Assert.assertEquals((String)"Should use timestamp conversion for date type", (Object)"new org.apache.avro.data.TimeConversions.TimestampMillisConversion()", (Object)compiler.conversionInstance(timestampSchema));
        Assert.assertEquals((String)"Should use null for decimal if the flag is off", (Object)"null", (Object)compiler.conversionInstance(decimalSchema));
        Assert.assertEquals((String)"Should use null for decimal if the flag is off", (Object)"null", (Object)compiler.conversionInstance(uuidSchema));
    }

    @Test
    public void testConversionInstanceWithDecimalLogicalTypeEnabled() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setEnableDecimalLogicalType(true);
        Schema dateSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeSchema = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timestampSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema decimalSchema = LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema uuidSchema = LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        Assert.assertEquals((String)"Should use date conversion for date type", (Object)"new org.apache.avro.data.TimeConversions.DateConversion()", (Object)compiler.conversionInstance(dateSchema));
        Assert.assertEquals((String)"Should use time conversion for time type", (Object)"new org.apache.avro.data.TimeConversions.TimeMillisConversion()", (Object)compiler.conversionInstance(timeSchema));
        Assert.assertEquals((String)"Should use timestamp conversion for date type", (Object)"new org.apache.avro.data.TimeConversions.TimestampMillisConversion()", (Object)compiler.conversionInstance(timestampSchema));
        Assert.assertEquals((String)"Should use null for decimal if the flag is off", (Object)"new org.apache.avro.Conversions.DecimalConversion()", (Object)compiler.conversionInstance(decimalSchema));
        Assert.assertEquals((String)"Should use null for decimal if the flag is off", (Object)"null", (Object)compiler.conversionInstance(uuidSchema));
    }

    @Test
    public void testPojoWithOptionalTurnedOffByDefault() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                Assert.assertFalse((boolean)line.contains("Optional"));
            }
        }
    }

    @Test
    public void testPojoWithOptionalCreatedWhenOptionTurnedOn() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setGettersReturnOptional(true);
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        int optionalFound = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).contains("Optional")) continue;
                ++optionalFound;
            }
        }
        Assert.assertEquals((long)9L, (long)optionalFound);
    }

    @Test
    public void testPojoWithOptionalCreatedWhenOptionalForEverythingTurnedOn() throws IOException {
        SpecificCompiler compiler = this.createCompiler();
        compiler.setCreateOptionalGetters(true);
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        int optionalFound = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).contains("Optional")) continue;
                ++optionalFound;
            }
        }
        Assert.assertEquals((long)17L, (long)optionalFound);
    }

    @Test
    public void testAdditionalToolsAreInjectedIntoTemplate() throws Exception {
        SpecificCompiler compiler = this.createCompiler();
        ArrayList<String> customTools = new ArrayList<String>();
        customTools.add(new String());
        compiler.setAdditionalVelocityTools(customTools);
        compiler.setTemplateDir("src/test/resources/templates_with_custom_tools/");
        compiler.compileToDestination(this.src, this.OUTPUT_DIR.getRoot());
        Assert.assertTrue((boolean)this.outputFile.exists());
        int itWorksFound = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).contains("It works!")) continue;
                ++itWorksFound;
            }
        }
        Assert.assertEquals((long)1L, (long)itWorksFound);
    }
}

