/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.idl.Idl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIdl {
    private static final File TEST_DIR = new File(System.getProperty("test.idl.dir", "src/test/idl"));
    private static final File TEST_INPUT_DIR = new File(TEST_DIR, "input");
    private static final File TEST_OUTPUT_DIR = new File(TEST_DIR, "output");
    private static final String TEST_MODE = System.getProperty("test.idl.mode", "run");
    private List<GenTest> tests;

    @Before
    public void loadTests() {
        Assert.assertTrue((boolean)TEST_DIR.exists());
        Assert.assertTrue((boolean)TEST_INPUT_DIR.exists());
        Assert.assertTrue((boolean)TEST_OUTPUT_DIR.exists());
        this.tests = new ArrayList<GenTest>();
        for (File inF : TEST_INPUT_DIR.listFiles()) {
            if (!inF.getName().endsWith(".avdl") || inF.getName().startsWith(".")) continue;
            File outF = new File(TEST_OUTPUT_DIR, inF.getName().replaceFirst("\\.avdl$", ".avpr"));
            this.tests.add(new GenTest(inF, outF));
        }
    }

    @Test
    public void runTests() throws Exception {
        if (!"run".equals(TEST_MODE)) {
            return;
        }
        int passed = 0;
        int failed = 0;
        for (GenTest t : this.tests) {
            try {
                t.run();
                ++passed;
            }
            catch (Exception e) {
                ++failed;
                System.err.println("Failed: " + t.testName());
                e.printStackTrace(System.err);
            }
        }
        if (failed > 0) {
            Assert.fail((String)(String.valueOf(failed) + " tests failed"));
        }
    }

    @Test
    public void writeTests() throws Exception {
        if (!"write".equals(TEST_MODE)) {
            return;
        }
        for (GenTest t : this.tests) {
            t.write();
        }
    }

    private static class GenTest {
        private final File in;
        private final File expectedOut;

        public GenTest(File in, File expectedOut) {
            this.in = in;
            this.expectedOut = expectedOut;
        }

        private String generate() throws Exception {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            File file = new File(".");
            String currentWorkPath = file.toURI().toURL().toString();
            String newPath = currentWorkPath + "src" + File.separator + "test" + File.separator + "idl" + File.separator + "putOnClassPath" + File.separator;
            URL[] newPathURL = new URL[]{new URL(newPath)};
            URLClassLoader ucl = new URLClassLoader(newPathURL, cl);
            Idl parser = new Idl(this.in, (ClassLoader)ucl);
            Protocol p = parser.CompilationUnit();
            parser.close();
            return p.toString();
        }

        public String testName() {
            return this.in.getName();
        }

        public void run() throws Exception {
            String output = this.generate();
            String slurped = GenTest.slurp(this.expectedOut);
            Assert.assertEquals((Object)slurped.trim(), (Object)output.replace("\\r", "").trim());
        }

        public void write() throws Exception {
            GenTest.writeFile(this.expectedOut, this.generate());
        }

        private static String slurp(File f) throws IOException {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = null;
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode json = mapper.readTree(builder.toString());
            return mapper.writer().writeValueAsString((Object)json);
        }

        private static void writeFile(File f, String s) throws IOException {
            FileWriter w = new FileWriter(f);
            w.write(s);
            w.close();
        }
    }
}

