/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.idl.SchemaResolver;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaResolver {
    @Test
    public void testResolving() throws ParseException, MalformedURLException, IOException {
        File file = new File(".");
        String currentWorkPath = file.getAbsolutePath();
        String testIdl = currentWorkPath + File.separator + "src" + File.separator + "test" + File.separator + "idl" + File.separator + "cycle.avdl";
        Idl compiler = new Idl(new File(testIdl));
        Protocol protocol = compiler.CompilationUnit();
        System.out.println(protocol);
        Assert.assertEquals((long)5L, (long)protocol.getTypes().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsUnresolvedSchemaError1() {
        Schema s = (Schema)SchemaBuilder.record((String)"R").fields().endRecord();
        SchemaResolver.getUnresolvedSchemaName((Schema)s);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsUnresolvedSchemaError2() {
        Schema s = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"R").prop("org.apache.avro.compiler.idl.unresolved.name", "x")).fields().endRecord();
        SchemaResolver.getUnresolvedSchemaName((Schema)s);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsUnresolvedSchemaError3() {
        Schema s = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"UnresolvedSchema").prop("org.apache.avro.compiler.idl.unresolved.name", "x")).fields().endRecord();
        SchemaResolver.getUnresolvedSchemaName((Schema)s);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUnresolvedSchemaNameError() {
        Schema s = (Schema)SchemaBuilder.fixed((String)"a").size(10);
        SchemaResolver.getUnresolvedSchemaName((Schema)s);
    }
}

