/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.junit.Assert;

public final class RPCMetaTestPlugin
extends RPCPlugin {
    protected final String key;

    public RPCMetaTestPlugin(String keyname) {
        this.key = keyname;
    }

    public void clientStartConnect(RPCContext context) {
        ByteBuffer buf = ByteBuffer.wrap("ap".getBytes(StandardCharsets.UTF_8));
        context.requestHandshakeMeta().put(this.key, buf);
    }

    public void serverConnecting(RPCContext context) {
        Assert.assertNotNull((Object)context.requestHandshakeMeta());
        Assert.assertNotNull((Object)context.responseHandshakeMeta());
        Assert.assertNull((Object)context.getRequestPayload());
        Assert.assertNull((Object)context.getResponsePayload());
        if (!context.requestHandshakeMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)context.requestHandshakeMeta().get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (Object)"ap", (Object)partialstr);
        buf = ByteBuffer.wrap((partialstr + "ac").getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseHandshakeMeta().put(this.key, buf);
    }

    public void clientFinishConnect(RPCContext context) {
        Map handshakeMeta = context.responseHandshakeMeta();
        Assert.assertNull((Object)context.getRequestPayload());
        Assert.assertNull((Object)context.getResponsePayload());
        Assert.assertNotNull((Object)handshakeMeta);
        if (!handshakeMeta.containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)handshakeMeta.get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (Object)"apac", (Object)partialstr);
        buf = ByteBuffer.wrap((partialstr + "he").getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        handshakeMeta.put(this.key, buf);
        this.checkRPCMetaMap(handshakeMeta);
    }

    public void clientSendRequest(RPCContext context) {
        ByteBuffer buf = ByteBuffer.wrap("ap".getBytes(StandardCharsets.UTF_8));
        context.requestCallMeta().put(this.key, buf);
        Assert.assertNotNull((Object)context.getMessage());
        Assert.assertNotNull((Object)context.getRequestPayload());
        Assert.assertNull((Object)context.getResponsePayload());
    }

    public void serverReceiveRequest(RPCContext context) {
        Map meta = context.requestCallMeta();
        Assert.assertNotNull((Object)meta);
        Assert.assertNotNull((Object)context.getMessage());
        Assert.assertNull((Object)context.getResponsePayload());
        if (!meta.containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)meta.get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (Object)"ap", (Object)partialstr);
        buf = ByteBuffer.wrap((partialstr + "a").getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        meta.put(this.key, buf);
    }

    public void serverSendResponse(RPCContext context) {
        Assert.assertNotNull((Object)context.requestCallMeta());
        Assert.assertNotNull((Object)context.responseCallMeta());
        Assert.assertNotNull((Object)context.getResponsePayload());
        if (!context.requestCallMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)context.requestCallMeta().get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (Object)"apa", (Object)partialstr);
        buf = ByteBuffer.wrap((partialstr + "c").getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseCallMeta().put(this.key, buf);
    }

    public void clientReceiveResponse(RPCContext context) {
        Assert.assertNotNull((Object)context.responseCallMeta());
        Assert.assertNotNull((Object)context.getRequestPayload());
        if (!context.responseCallMeta().containsKey(this.key)) {
            return;
        }
        ByteBuffer buf = (ByteBuffer)context.responseCallMeta().get(this.key);
        Assert.assertNotNull((Object)buf);
        Assert.assertNotNull((Object)buf.array());
        String partialstr = new String(buf.array(), StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)partialstr);
        Assert.assertEquals((String)"partial string mismatch", (Object)"apac", (Object)partialstr);
        buf = ByteBuffer.wrap((partialstr + "he").getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((buf.remaining() > 0 ? 1 : 0) != 0);
        context.responseCallMeta().put(this.key, buf);
        this.checkRPCMetaMap(context.responseCallMeta());
    }

    protected void checkRPCMetaMap(Map<String, ByteBuffer> rpcMeta) {
        Assert.assertNotNull(rpcMeta);
        Assert.assertTrue((String)"key not present in map", (boolean)rpcMeta.containsKey(this.key));
        ByteBuffer keybuf = rpcMeta.get(this.key);
        Assert.assertNotNull((Object)keybuf);
        Assert.assertTrue((String)"key BB had nothing remaining", (keybuf.remaining() > 0 ? 1 : 0) != 0);
        String str = new String(keybuf.array(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"apache", (Object)str);
    }
}

