/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.TestAnnotation;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;

@TestAnnotation
@AvroGenerated
public class TestRecord
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 2530317830657753100L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TestRecord\",\"namespace\":\"org.apache.avro.test\",\"fields\":[{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"order\":\"ignore\",\"javaAnnotation\":\"org.apache.avro.TestAnnotation\"},{\"name\":\"kind\",\"type\":{\"type\":\"enum\",\"name\":\"Kind\",\"symbols\":[\"FOO\",\"BAR\",\"BAZ\"],\"javaAnnotation\":\"org.apache.avro.TestAnnotation\"},\"order\":\"descending\"},{\"name\":\"hash\",\"type\":{\"type\":\"fixed\",\"name\":\"MD5\",\"size\":16,\"javaAnnotation\":\"org.apache.avro.TestAnnotation\"}}],\"javaAnnotation\":\"org.apache.avro.TestAnnotation\"}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<TestRecord> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<TestRecord> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @TestAnnotation
    @Deprecated
    public String name;
    @Deprecated
    public Kind kind;
    @Deprecated
    public MD5 hash;
    private static final DatumWriter<TestRecord> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<TestRecord> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<TestRecord> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<TestRecord> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<TestRecord> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static TestRecord fromByteBuffer(ByteBuffer b) throws IOException {
        return (TestRecord)((Object)DECODER.decode(b));
    }

    public TestRecord() {
    }

    public TestRecord(String name, Kind kind, MD5 hash) {
        this.name = name;
        this.kind = kind;
        this.hash = hash;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.kind;
            }
            case 2: {
                return this.hash;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.name = (String)value$;
                break;
            }
            case 1: {
                this.kind = (Kind)((Object)value$);
                break;
            }
            case 2: {
                this.hash = (MD5)((Object)value$);
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getOptionalName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(String value2) {
        this.name = value2;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Optional<Kind> getOptionalKind() {
        return Optional.ofNullable(this.kind);
    }

    public void setKind(Kind value2) {
        this.kind = value2;
    }

    public MD5 getHash() {
        return this.hash;
    }

    public Optional<MD5> getOptionalHash() {
        return Optional.ofNullable(this.hash);
    }

    public void setHash(MD5 value2) {
        this.hash = value2;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(TestRecord other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    protected void customEncode(Encoder out) throws IOException {
        out.writeString(this.name);
        out.writeEnum(this.kind.ordinal());
        out.writeFixed(this.hash.bytes(), 0, 16);
    }

    protected void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.name = in.readString();
            this.kind = Kind.values()[in.readEnum()];
            if (this.hash == null) {
                this.hash = new MD5();
            }
            in.readFixed(this.hash.bytes(), 0, 16);
        } else {
            block5: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.name = in.readString();
                        continue block5;
                    }
                    case 1: {
                        this.kind = Kind.values()[in.readEnum()];
                        continue block5;
                    }
                    case 2: {
                        if (this.hash == null) {
                            this.hash = new MD5();
                        }
                        in.readFixed(this.hash.bytes(), 0, 16);
                        continue block5;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    public static class Builder
    extends SpecificRecordBuilderBase<TestRecord>
    implements RecordBuilder<TestRecord> {
        private String name;
        private Kind kind;
        private MD5 hash;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.kind))) {
                this.kind = (Kind)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.kind));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.hash))) {
                this.hash = (MD5)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.hash));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(TestRecord other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.kind))) {
                this.kind = (Kind)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.kind));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.hash))) {
                this.hash = (MD5)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.hash));
                this.fieldSetFlags()[2] = true;
            }
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getOptionalName() {
            return Optional.ofNullable(this.name);
        }

        public Builder setName(String value2) {
            this.validate(this.fields()[0], value2);
            this.name = value2;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Kind getKind() {
            return this.kind;
        }

        public Optional<Kind> getOptionalKind() {
            return Optional.ofNullable(this.kind);
        }

        public Builder setKind(Kind value2) {
            this.validate(this.fields()[1], (Object)value2);
            this.kind = value2;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasKind() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearKind() {
            this.kind = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public MD5 getHash() {
            return this.hash;
        }

        public Optional<MD5> getOptionalHash() {
            return Optional.ofNullable(this.hash);
        }

        public Builder setHash(MD5 value2) {
            this.validate(this.fields()[2], (Object)value2);
            this.hash = value2;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasHash() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearHash() {
            this.hash = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public TestRecord build() {
            try {
                TestRecord record = new TestRecord();
                record.name = this.fieldSetFlags()[0] ? this.name : (String)this.defaultValue(this.fields()[0]);
                record.kind = this.fieldSetFlags()[1] ? this.kind : (Kind)((Object)this.defaultValue(this.fields()[1]));
                record.hash = this.fieldSetFlags()[2] ? this.hash : (MD5)((Object)this.defaultValue(this.fields()[2]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

