/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.specific;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

public class SpecificRequestor
extends Requestor
implements InvocationHandler {
    SpecificData data;

    public SpecificRequestor(Class<?> iface, Transceiver transceiver) throws IOException {
        this(iface, transceiver, new SpecificData(iface.getClassLoader()));
    }

    protected SpecificRequestor(Protocol protocol, Transceiver transceiver) throws IOException {
        this(protocol, transceiver, SpecificData.get());
    }

    public SpecificRequestor(Class<?> iface, Transceiver transceiver, SpecificData data) throws IOException {
        this(data.getProtocol(iface), transceiver, data);
    }

    public SpecificRequestor(Protocol protocol, Transceiver transceiver, SpecificData data) throws IOException {
        super(protocol, transceiver);
        this.data = data;
    }

    public SpecificData getSpecificData() {
        return this.data;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name;
        switch (name = method.getName()) {
            case "hashCode": {
                return this.hashCode();
            }
            case "equals": {
                Object obj = args[0];
                return proxy == obj || obj != null && Proxy.isProxyClass(obj.getClass()) && this.equals(Proxy.getInvocationHandler(obj));
            }
            case "toString": {
                String protocol = "unknown";
                String remote = "unknown";
                Class<?>[] interfaces = proxy.getClass().getInterfaces();
                if (interfaces.length > 0) {
                    try {
                        protocol = Class.forName(interfaces[0].getName()).getSimpleName();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    InvocationHandler handler = Proxy.getInvocationHandler(proxy);
                    if (handler instanceof Requestor) {
                        try {
                            remote = ((Requestor)((Object)handler)).getTransceiver().getRemoteName();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                return "Proxy[" + protocol + "," + remote + "]";
            }
        }
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1] instanceof Class && Callback.class.isAssignableFrom(parameterTypes[parameterTypes.length - 1])) {
                Object[] finalArgs = Arrays.copyOf(args, args.length - 1);
                Callback callback = (Callback)args[args.length - 1];
                this.request(method.getName(), finalArgs, callback);
                return null;
            }
            return this.request(method.getName(), args);
        }
        catch (Exception e) {
            for (Class<?> exceptionClass : method.getExceptionTypes()) {
                if (!exceptionClass.isAssignableFrom(e.getClass())) continue;
                throw e;
            }
            if (e instanceof RuntimeException) {
                throw e;
            }
            throw new AvroRemoteException((Throwable)e);
        }
    }

    protected DatumWriter<Object> getDatumWriter(Schema schema) {
        return new SpecificDatumWriter(schema, this.data);
    }

    @Deprecated
    protected DatumReader<Object> getDatumReader(Schema schema) {
        return this.getDatumReader(schema, schema);
    }

    protected DatumReader<Object> getDatumReader(Schema writer, Schema reader) {
        return new SpecificDatumReader(writer, reader, this.data);
    }

    @Override
    public void writeRequest(Schema schema, Object request, Encoder out) throws IOException {
        Object[] args = (Object[])request;
        int i = 0;
        for (Schema.Field param : schema.getFields()) {
            this.getDatumWriter(param.schema()).write(args[i++], out);
        }
    }

    @Override
    public Object readResponse(Schema writer, Schema reader, Decoder in) throws IOException {
        return this.getDatumReader(writer, reader).read(null, in);
    }

    @Override
    public Exception readError(Schema writer, Schema reader, Decoder in) throws IOException {
        Object value = this.getDatumReader(writer, reader).read(null, in);
        if (value instanceof Exception) {
            return (Exception)value;
        }
        return new AvroRuntimeException(value.toString());
    }

    public static <T> T getClient(Class<T> iface, Transceiver transceiver) throws IOException {
        return SpecificRequestor.getClient(iface, transceiver, new SpecificData(iface.getClassLoader()));
    }

    public static <T> T getClient(Class<T> iface, Transceiver transceiver, SpecificData data) throws IOException {
        Protocol protocol = data.getProtocol(iface);
        return (T)Proxy.newProxyInstance(data.getClassLoader(), new Class[]{iface}, (InvocationHandler)new SpecificRequestor(protocol, transceiver, data));
    }

    public static <T> T getClient(Class<T> iface, SpecificRequestor requestor) throws IOException {
        return (T)Proxy.newProxyInstance(requestor.data.getClassLoader(), new Class[]{iface}, (InvocationHandler)requestor);
    }

    public static Protocol getRemote(Object proxy) throws IOException {
        return ((Requestor)((Object)Proxy.getInvocationHandler(proxy))).getRemote();
    }
}

