/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapreduce.AvroKeyValueOutputFormat;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestKeyValueWordCount {
    @Rule
    public TemporaryFolder mTempDir = new TemporaryFolder();

    @Test
    public void testKeyValueMapReduce() throws ClassNotFoundException, IOException, InterruptedException, URISyntaxException {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.txt").toURI().toString())});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(LineCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(IntSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setOutputFormatClass(AvroKeyValueOutputFormat.class);
        Path outputPath = new Path(this.mTempDir.getRoot().getPath() + "/out-wordcount");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        File avroFile = new File(outputPath.toString(), "part-r-00000.avro");
        SpecificDatumReader datumReader = new SpecificDatumReader(AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.STRING), (Schema)Schema.create((Schema.Type)Schema.Type.INT)));
        DataFileReader avroFileReader = new DataFileReader(avroFile, (DatumReader)datumReader);
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue appleRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertNotNull((Object)appleRecord.get());
        Assert.assertEquals((Object)"apple", (Object)((CharSequence)appleRecord.getKey()).toString());
        Assert.assertEquals((long)3L, (long)((Integer)appleRecord.getValue()).intValue());
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue bananaRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertNotNull((Object)bananaRecord.get());
        Assert.assertEquals((Object)"banana", (Object)((CharSequence)bananaRecord.getKey()).toString());
        Assert.assertEquals((long)2L, (long)((Integer)bananaRecord.getValue()).intValue());
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue carrotRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertEquals((Object)"carrot", (Object)((CharSequence)carrotRecord.getKey()).toString());
        Assert.assertEquals((long)1L, (long)((Integer)carrotRecord.getValue()).intValue());
        Assert.assertFalse((boolean)avroFileReader.hasNext());
        avroFileReader.close();
    }

    public static class IntSumReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        protected void reduce(Text word, Iterable<IntWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable count : counts) {
                sum += count.get();
            }
            context.write((Object)word, (Object)new IntWritable(sum));
        }
    }

    public static class LineCountMapper
    extends Mapper<LongWritable, Text, Text, IntWritable> {
        private IntWritable mOne;

        protected void setup(Mapper.Context context) {
            this.mOne = new IntWritable(1);
        }

        protected void map(LongWritable fileByteOffset, Text line, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)line, (Object)this.mOne);
        }
    }
}

