/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroKeyRecordWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroKeyRecordWriter {
    @Test
    public void testWrite() throws IOException {
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.INT);
        ReflectData dataModel = new ReflectData();
        CodecFactory compressionCodec = CodecFactory.nullCodec();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TaskAttemptContext context = (TaskAttemptContext)EasyMock.createMock(TaskAttemptContext.class);
        EasyMock.replay((Object[])new Object[]{context});
        AvroKeyRecordWriter recordWriter = new AvroKeyRecordWriter(writerSchema, (GenericData)dataModel, compressionCodec, (OutputStream)outputStream);
        recordWriter.write(new AvroKey((Object)1), NullWritable.get());
        recordWriter.write(new AvroKey((Object)2), NullWritable.get());
        recordWriter.close(context);
        EasyMock.verify((Object[])new Object[]{context});
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.INT);
        SpecificDatumReader datumReader = new SpecificDatumReader(readerSchema);
        DataFileStream dataFileReader = new DataFileStream((InputStream)inputStream, (DatumReader)datumReader);
        Assert.assertTrue((boolean)dataFileReader.hasNext());
        Assert.assertEquals((long)1L, (long)((Integer)dataFileReader.next()).intValue());
        Assert.assertTrue((boolean)dataFileReader.hasNext());
        Assert.assertEquals((long)2L, (long)((Integer)dataFileReader.next()).intValue());
        Assert.assertFalse((boolean)dataFileReader.hasNext());
        dataFileReader.close();
    }

    @Test
    public void testSycnableWrite() throws IOException {
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.INT);
        ReflectData dataModel = new ReflectData();
        CodecFactory compressionCodec = CodecFactory.nullCodec();
        FileOutputStream outputStream = new FileOutputStream(new File("target/temp.avro"));
        TaskAttemptContext context = (TaskAttemptContext)EasyMock.createMock(TaskAttemptContext.class);
        EasyMock.replay((Object[])new Object[]{context});
        AvroKeyRecordWriter recordWriter = new AvroKeyRecordWriter(writerSchema, (GenericData)dataModel, compressionCodec, (OutputStream)outputStream);
        long positionOne = recordWriter.sync();
        recordWriter.write(new AvroKey((Object)1), NullWritable.get());
        long positionTwo = recordWriter.sync();
        recordWriter.write(new AvroKey((Object)2), NullWritable.get());
        recordWriter.close(context);
        EasyMock.verify((Object[])new Object[]{context});
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        Path avroFile = new Path("target/temp.avro");
        DataFileReader dataFileReader = new DataFileReader((SeekableInput)new FsInput(avroFile, conf), (DatumReader)new SpecificDatumReader());
        dataFileReader.seek(positionTwo);
        Assert.assertTrue((boolean)dataFileReader.hasNext());
        Assert.assertEquals((Object)2, (Object)dataFileReader.next());
        dataFileReader.seek(positionOne);
        Assert.assertTrue((boolean)dataFileReader.hasNext());
        Assert.assertEquals((Object)1, (Object)dataFileReader.next());
        dataFileReader.close();
    }
}

