/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroFiles;
import org.apache.avro.mapreduce.AvroKeyValueRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroKeyValueRecordReader {
    @Rule
    public TemporaryFolder mTempDir = new TemporaryFolder();

    @Test
    public void testReadRecords() throws IOException, InterruptedException {
        Schema keyValueSchema = AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.STRING), (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroKeyValue firstInputRecord = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        firstInputRecord.setKey((Object)"first");
        firstInputRecord.setValue((Object)1);
        AvroKeyValue secondInputRecord = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        secondInputRecord.setKey((Object)"second");
        secondInputRecord.setValue((Object)2);
        SeekableFileInput avroFileInput = new SeekableFileInput(AvroFiles.createFile(new File(this.mTempDir.getRoot(), "myInputFile.avro"), keyValueSchema, firstInputRecord.get(), secondInputRecord.get()));
        AvroKeyValueRecordReader<CharSequence, Integer> recordReader = new AvroKeyValueRecordReader<CharSequence, Integer>(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.INT), (SeekableInput)avroFileInput){
            final /* synthetic */ SeekableInput val$avroFileInput;
            {
                this.val$avroFileInput = seekableInput;
                super(x0, x1);
            }

            protected SeekableInput createSeekableInput(Configuration conf, Path path) throws IOException {
                return this.val$avroFileInput;
            }
        };
        Configuration conf = new Configuration();
        FileSplit inputSplit = (FileSplit)EasyMock.createMock(FileSplit.class);
        EasyMock.expect((Object)inputSplit.getPath()).andReturn((Object)new Path("/path/to/an/avro/file")).anyTimes();
        EasyMock.expect((Object)inputSplit.getStart()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)inputSplit.getLength()).andReturn((Object)avroFileInput.length()).anyTimes();
        TaskAttemptContext context = (TaskAttemptContext)EasyMock.createMock(TaskAttemptContext.class);
        EasyMock.expect((Object)context.getConfiguration()).andReturn((Object)conf).anyTimes();
        EasyMock.replay((Object[])new Object[]{inputSplit});
        EasyMock.replay((Object[])new Object[]{context});
        recordReader.initialize((InputSplit)inputSplit, context);
        Assert.assertEquals((String)"Progress should be zero before any records are read", (float)0.0f, (float)recordReader.getProgress(), (float)0.0f);
        Assert.assertTrue((String)"Expected at least one record", (boolean)recordReader.nextKeyValue());
        AvroKey key = (AvroKey)recordReader.getCurrentKey();
        AvroValue value = (AvroValue)recordReader.getCurrentValue();
        Assert.assertNotNull((String)"First record had null key", (Object)key);
        Assert.assertNotNull((String)"First record had null value", (Object)value);
        Assert.assertEquals((Object)"first", (Object)((CharSequence)key.datum()).toString());
        Assert.assertEquals((long)1L, (long)((Integer)value.datum()).intValue());
        Assert.assertTrue((String)"getCurrentKey() returned different keys for the same record", (key == recordReader.getCurrentKey() ? 1 : 0) != 0);
        Assert.assertTrue((String)"getCurrentValue() returned different values for the same record", (value == recordReader.getCurrentValue() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected to read a second record", (boolean)recordReader.nextKeyValue());
        key = (AvroKey)recordReader.getCurrentKey();
        value = (AvroValue)recordReader.getCurrentValue();
        Assert.assertNotNull((String)"Second record had null key", (Object)key);
        Assert.assertNotNull((String)"Second record had null value", (Object)value);
        Assert.assertEquals((Object)"second", (Object)((CharSequence)key.datum()).toString());
        Assert.assertEquals((long)2L, (long)((Integer)value.datum()).intValue());
        Assert.assertEquals((String)"Progress should be complete (2 out of 2 records processed)", (float)1.0f, (float)recordReader.getProgress(), (float)0.0f);
        Assert.assertFalse((String)"Expected only 2 records", (boolean)recordReader.nextKeyValue());
        recordReader.close();
        EasyMock.verify((Object[])new Object[]{inputSplit});
        EasyMock.verify((Object[])new Object[]{context});
    }
}

