/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.avro.mapreduce.AvroMultipleOutputs;
import org.apache.avro.mapreduce.TextStats;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroMultipleOutputsSyncable {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    public static final Schema STATS_SCHEMA = new Schema.Parser().parse("{\"name\":\"stats\",\"type\":\"record\",\"fields\":[{\"name\":\"count\",\"type\":\"int\"},{\"name\":\"name\",\"type\":\"string\"}]}");
    public static final Schema STATS_SCHEMA_2 = new Schema.Parser().parse("{\"name\":\"stats\",\"type\":\"record\",\"fields\":[{\"name\":\"count1\",\"type\":\"int\"},{\"name\":\"name1\",\"type\":\"string\"}]}");

    @Test
    public void testAvroGenericOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.txt").toURI().toString())});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(LineCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(GenericStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)STATS_SCHEMA);
        AvroMultipleOutputs.addNamedOutput((Job)job, (String)"myavro", AvroKeyOutputFormat.class, (Schema)STATS_SCHEMA, null);
        AvroMultipleOutputs.addNamedOutput((Job)job, (String)"myavro1", AvroKeyOutputFormat.class, (Schema)STATS_SCHEMA_2);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getRoot().getPath() + "/out");
        outputPath.getFileSystem(job.getConfiguration()).delete(outputPath, true);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/myavro-r-00000.avro"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new GenericDatumReader(STATS_SCHEMA));
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (GenericData.Record record : reader) {
            counts.put(((Utf8)record.get("name")).toString(), (Integer)record.get("count"));
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
        outputFiles = fileSystem.globStatus(outputPath.suffix("/myavro1-r-00000.avro"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new GenericDatumReader(STATS_SCHEMA_2));
        counts = new HashMap();
        for (GenericData.Record record : reader) {
            counts.put(((Utf8)record.get("name1")).toString(), (Integer)record.get("count1"));
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
        outputFiles = fileSystem.globStatus(outputPath.suffix("/testnewwrite-r-00000.avro"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new GenericDatumReader(STATS_SCHEMA));
        counts = new HashMap();
        for (GenericData.Record record : reader) {
            counts.put(((Utf8)record.get("name")).toString(), (Integer)record.get("count"));
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
        outputFiles = fileSystem.globStatus(outputPath.suffix("/testnewwrite2-r-00000.avro"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new GenericDatumReader(STATS_SCHEMA_2));
        counts = new HashMap();
        for (GenericData.Record record : reader) {
            counts.put(((Utf8)record.get("name1")).toString(), (Integer)record.get("count1"));
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
        outputFiles = fileSystem.globStatus(outputPath.suffix("/testwritenonschema-r-00000.avro"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new GenericDatumReader(STATS_SCHEMA));
        counts = new HashMap();
        for (GenericData.Record record : reader) {
            counts.put(((Utf8)record.get("name")).toString(), (Integer)record.get("count"));
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
    }

    @Test
    public void testAvroSpecificOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.txt").toURI().toString())});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(LineCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        AvroMultipleOutputs.addNamedOutput((Job)job, (String)"myavro3", AvroKeyOutputFormat.class, (Schema)TextStats.SCHEMA$, null);
        job.setReducerClass(SpecificStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getRoot().getPath() + "/out-specific");
        outputPath.getFileSystem(job.getConfiguration()).delete(outputPath, true);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/myavro3-*"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new SpecificDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (TextStats record : reader) {
            counts.put(record.getName().toString(), record.getCount());
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
    }

    @Test
    public void testAvroInput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.avro").toURI().toString())});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        AvroMultipleOutputs.addNamedOutput((Job)job, (String)"myavro3", AvroKeyOutputFormat.class, (Schema)TextStats.SCHEMA$, null);
        job.setMapperClass(StatCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(SpecificStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getRoot().getPath() + "/out-specific-input");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/myavro3-*"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new SpecificDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (TextStats record : reader) {
            counts.put(record.getName().toString(), record.getCount());
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
    }

    @Test
    public void testAvroMapOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.avro").toURI().toString())});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setMapperClass(SortMapper.class);
        AvroJob.setMapOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(SortReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getRoot().getPath() + "/out-specific-input");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assert.assertEquals((long)1L, (long)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new SpecificDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (TextStats record : reader) {
            counts.put(record.getName().toString(), record.getCount());
        }
        reader.close();
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("apple")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)counts.get("banana")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get("carrot")).intValue());
    }

    private static class SortReducer
    extends Reducer<AvroKey<TextStats>, NullWritable, AvroKey<TextStats>, NullWritable> {
        private SortReducer() {
        }

        protected void reduce(AvroKey<TextStats> key, Iterable<NullWritable> ignore, Reducer.Context context) throws IOException, InterruptedException {
            context.write(key, (Object)NullWritable.get());
        }
    }

    private static class SortMapper
    extends Mapper<AvroKey<TextStats>, NullWritable, AvroKey<TextStats>, NullWritable> {
        private SortMapper() {
        }

        protected void map(AvroKey<TextStats> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(key, (Object)value);
        }
    }

    private static class SpecificStatsReducer
    extends Reducer<Text, IntWritable, AvroKey<TextStats>, NullWritable> {
        private AvroKey<TextStats> mStats;
        private AvroMultipleOutputs amos;

        private SpecificStatsReducer() {
        }

        protected void setup(Reducer.Context context) {
            this.mStats = new AvroKey(null);
            this.amos = new AvroMultipleOutputs((TaskInputOutputContext)context);
        }

        protected void reduce(Text line, Iterable<IntWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            TextStats record = new TextStats();
            record.setCount(0);
            for (IntWritable count : counts) {
                record.setCount(record.getCount() + count.get());
            }
            record.setName(line.toString());
            this.mStats.datum((Object)record);
            context.write(this.mStats, (Object)NullWritable.get());
            this.amos.sync("myavro3", "myavro3");
            this.amos.write("myavro3", this.mStats, (Object)NullWritable.get());
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.amos.close();
        }
    }

    private static class GenericStatsReducer
    extends Reducer<Text, IntWritable, AvroKey<GenericData.Record>, NullWritable> {
        private AvroKey<GenericData.Record> mStats;
        private AvroMultipleOutputs amos;

        private GenericStatsReducer() {
        }

        protected void setup(Reducer.Context context) {
            this.mStats = new AvroKey(null);
            this.amos = new AvroMultipleOutputs((TaskInputOutputContext)context);
        }

        protected void reduce(Text line, Iterable<IntWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            GenericData.Record record = new GenericData.Record(STATS_SCHEMA);
            GenericData.Record record2 = new GenericData.Record(STATS_SCHEMA_2);
            int sum = 0;
            for (IntWritable count : counts) {
                sum += count.get();
            }
            record.put("name", (Object)new Utf8(line.toString()));
            record.put("count", (Object)sum);
            this.mStats.datum((Object)record);
            context.write(this.mStats, (Object)NullWritable.get());
            this.amos.sync("myavro", "myavro");
            this.amos.write("myavro", this.mStats, (Object)NullWritable.get());
            record2.put("name1", (Object)new Utf8(line.toString()));
            record2.put("count1", (Object)sum);
            this.mStats.datum((Object)record2);
            this.amos.write(this.mStats, (Object)NullWritable.get(), STATS_SCHEMA_2, null, "testnewwrite2");
            this.amos.sync("myavro1", "myavro1");
            this.amos.write("myavro1", this.mStats);
            this.amos.write(this.mStats, (Object)NullWritable.get(), STATS_SCHEMA, null, "testnewwrite");
            this.amos.write(this.mStats, (Object)NullWritable.get(), "testwritenonschema");
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.amos.close();
        }
    }

    private static class StatCountMapper
    extends Mapper<AvroKey<TextStats>, NullWritable, Text, IntWritable> {
        private IntWritable mCount;
        private Text mText;

        private StatCountMapper() {
        }

        protected void setup(Mapper.Context context) {
            this.mCount = new IntWritable(0);
            this.mText = new Text("");
        }

        protected void map(AvroKey<TextStats> record, NullWritable ignore, Mapper.Context context) throws IOException, InterruptedException {
            this.mCount.set(((TextStats)((Object)record.datum())).getCount());
            this.mText.set(((TextStats)((Object)record.datum())).getName().toString());
            context.write((Object)this.mText, (Object)this.mCount);
        }
    }

    private static class LineCountMapper
    extends Mapper<LongWritable, Text, Text, IntWritable> {
        private IntWritable mOne;

        private LineCountMapper() {
        }

        protected void setup(Mapper.Context context) {
            this.mOne = new IntWritable(1);
        }

        protected void map(LongWritable fileByteOffset, Text line, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)line, (Object)this.mOne);
        }
    }
}

