/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFsInput {
    private static File file;
    private static final String FILE_CONTENTS = "abcdefghijklmnopqrstuvwxyz";
    private Configuration conf;
    private FsInput fsInput;
    @Rule
    public TemporaryFolder DIR = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        file = new File(this.DIR.getRoot(), "file.txt");
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            out.print(FILE_CONTENTS);
        }
        this.fsInput = new FsInput(new Path(file.getPath()), this.conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.fsInput != null) {
            this.fsInput.close();
        }
    }

    @Test
    public void testConfigurationConstructor() throws Exception {
        try (FsInput in = new FsInput(new Path(file.getPath()), this.conf);){
            int expectedByteCount = 1;
            byte[] readBytes = new byte[expectedByteCount];
            int actualByteCount = this.fsInput.read(readBytes, 0, expectedByteCount);
            Assert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByteCount)));
        }
    }

    @Test
    public void testFileSystemConstructor() throws Exception {
        Path path = new Path(file.getPath());
        FileSystem fs = path.getFileSystem(this.conf);
        try (FsInput in = new FsInput(path, fs);){
            int expectedByteCount = 1;
            byte[] readBytes = new byte[expectedByteCount];
            int actualByteCount = this.fsInput.read(readBytes, 0, expectedByteCount);
            Assert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByteCount)));
        }
    }

    @Test
    public void testLength() throws IOException {
        Assert.assertEquals((long)this.fsInput.length(), (long)FILE_CONTENTS.length());
    }

    @Test
    public void testRead() throws Exception {
        byte[] expectedBytes = FILE_CONTENTS.getBytes(StandardCharsets.UTF_8);
        byte[] actualBytes = new byte[expectedBytes.length];
        int actualByteCount = this.fsInput.read(actualBytes, 0, actualBytes.length);
        Assert.assertThat((Object)actualBytes, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedBytes)));
        Assert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedBytes.length)));
    }

    @Test
    public void testSeek() throws Exception {
        int seekPos = FILE_CONTENTS.length() / 2;
        byte[] fileContentBytes = FILE_CONTENTS.getBytes(StandardCharsets.UTF_8);
        byte expectedByte = fileContentBytes[seekPos];
        this.fsInput.seek((long)seekPos);
        byte[] readBytes = new byte[1];
        this.fsInput.read(readBytes, 0, 1);
        byte actualByte = readBytes[0];
        Assert.assertThat((Object)actualByte, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByte)));
    }

    @Test
    public void testTell() throws Exception {
        long expectedTellPos = FILE_CONTENTS.length() / 2;
        this.fsInput.seek(expectedTellPos);
        long actualTellPos = this.fsInput.tell();
        Assert.assertThat((Object)actualTellPos, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedTellPos)));
    }
}

