/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.hadoop.io.AvroDatumConverter;
import org.apache.avro.hadoop.io.AvroDatumConverterFactory;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAvroDatumConverterFactory {
    private Job mJob;
    private AvroDatumConverterFactory mFactory;

    @Before
    public void setup() throws IOException {
        this.mJob = Job.getInstance();
        this.mFactory = new AvroDatumConverterFactory(this.mJob.getConfiguration());
    }

    @Test
    public void testConvertAvroKey() throws IOException {
        AvroJob.setOutputKeySchema((Job)this.mJob, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroKey avroKey = new AvroKey((Object)"foo");
        AvroDatumConverter converter = this.mFactory.create(avroKey.getClass());
        Assert.assertEquals((Object)"foo", (Object)converter.convert((Object)avroKey).toString());
    }

    @Test
    public void testConvertAvroValue() throws IOException {
        AvroJob.setOutputValueSchema((Job)this.mJob, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroValue avroValue = new AvroValue((Object)42);
        AvroDatumConverter converter = this.mFactory.create(avroValue.getClass());
        Assert.assertEquals((long)42L, (long)((Integer)converter.convert((Object)avroValue)).intValue());
    }

    @Test
    public void testConvertBooleanWritable() {
        AvroDatumConverter converter = this.mFactory.create(BooleanWritable.class);
        Assert.assertEquals((Object)true, (Object)converter.convert((Object)new BooleanWritable(true)));
    }

    @Test
    public void testConvertBytesWritable() {
        AvroDatumConverter converter = this.mFactory.create(BytesWritable.class);
        ByteBuffer bytes = (ByteBuffer)converter.convert((Object)new BytesWritable(new byte[]{1, 2, 3}));
        Assert.assertEquals((long)1L, (long)bytes.get(0));
        Assert.assertEquals((long)2L, (long)bytes.get(1));
        Assert.assertEquals((long)3L, (long)bytes.get(2));
    }

    @Test
    public void testConvertByteWritable() {
        AvroDatumConverter converter = this.mFactory.create(ByteWritable.class);
        Assert.assertEquals((long)42L, (long)((GenericFixed)converter.convert((Object)new ByteWritable(42))).bytes()[0]);
    }

    @Test
    public void testConvertDoubleWritable() {
        AvroDatumConverter converter = this.mFactory.create(DoubleWritable.class);
        Assert.assertEquals((double)2.0, (double)((Double)converter.convert((Object)new DoubleWritable(2.0))), (double)1.0E-5);
    }

    @Test
    public void testConvertFloatWritable() {
        AvroDatumConverter converter = this.mFactory.create(FloatWritable.class);
        Assert.assertEquals((double)2.2f, (double)((Float)converter.convert((Object)new FloatWritable(2.2f))).floatValue(), (double)1.0E-5);
    }

    @Test
    public void testConvertIntWritable() {
        AvroDatumConverter converter = this.mFactory.create(IntWritable.class);
        Assert.assertEquals((long)2L, (long)((Integer)converter.convert((Object)new IntWritable(2))).intValue());
    }

    @Test
    public void testConvertLongWritable() {
        AvroDatumConverter converter = this.mFactory.create(LongWritable.class);
        Assert.assertEquals((long)123L, (long)((Long)converter.convert((Object)new LongWritable(123L))));
    }

    @Test
    public void testConvertNullWritable() {
        AvroDatumConverter converter = this.mFactory.create(NullWritable.class);
        Assert.assertNull((Object)converter.convert((Object)NullWritable.get()));
    }

    @Test
    public void testConvertText() {
        AvroDatumConverter converter = this.mFactory.create(Text.class);
        Assert.assertEquals((Object)"foo", (Object)((CharSequence)converter.convert((Object)new Text("foo"))).toString());
    }
}

