/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class LongTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        int i = 0;
        while (i < state.getBatchSize()) {
            e.writeLong(state.testData[i + 0]);
            e.writeLong(state.testData[i + 1]);
            e.writeLong(state.testData[i + 2]);
            e.writeLong(state.testData[i + 3]);
            i += 4;
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public long decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        long total = 0L;
        int i = 0;
        while (i < state.getBatchSize()) {
            total += d.readLong();
            total += d.readLong();
            total += d.readLong();
            total += d.readLong();
            i += 4;
        }
        return total;
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            int i = 0;
            while (i < this.getBatchSize()) {
                encoder.writeLong(super.getRandom().nextLong() % 127L);
                encoder.writeLong(super.getRandom().nextLong() % 0x1FFFFFL);
                encoder.writeLong(super.getRandom().nextLong() % 0x3FFFFFFFFL);
                encoder.writeLong(super.getRandom().nextLong() % 0x1FFFFFFFFFFFFL);
                i += 4;
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private long[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new long[this.getBatchSize()];
            int i = 0;
            while (i < this.testData.length) {
                this.testData[i + 0] = super.getRandom().nextLong() % 127L;
                this.testData[i + 1] = super.getRandom().nextLong() % 0x1FFFFFL;
                this.testData[i + 2] = super.getRandom().nextLong() % 0x3FFFFFFFFL;
                this.testData[i + 3] = super.getRandom().nextLong() % 0x1FFFFFFFFFFFFL;
                i += 4;
            }
        }
    }
}

