/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class GenericNestedTest {
    private static final String NESTED_RECORD_SCHEMA = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \n{ \"type\": \"record\", \"name\": \"D\", \"fields\": [\n{\"name\": \"dbl\", \"type\": \"double\" }]\n} },\n{ \"name\": \"f2\", \"type\": \"D\" },\n{ \"name\": \"f3\", \"type\": \"D\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }";

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        for (GenericRecord rec : state.testData) {
            GenericRecord inner = (GenericRecord)rec.get(0);
            e.writeDouble(((Double)inner.get(0)).doubleValue());
            inner = (GenericRecord)rec.get(1);
            e.writeDouble(((Double)inner.get(0)).doubleValue());
            inner = (GenericRecord)rec.get(2);
            e.writeDouble(((Double)inner.get(0)).doubleValue());
            e.writeInt(((Integer)rec.get(3)).intValue());
            e.writeInt(((Integer)rec.get(4)).intValue());
            e.writeInt(((Integer)rec.get(5)).intValue());
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(Blackhole blackhole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        Schema doubleSchema = ((Schema.Field)state.schema.getFields().get(0)).schema();
        for (int i = 0; i < state.getBatchSize(); ++i) {
            GenericData.Record rec = new GenericData.Record(state.schema);
            GenericData.Record inner = new GenericData.Record(doubleSchema);
            inner.put(0, (Object)d.readDouble());
            rec.put(0, (Object)inner);
            inner = new GenericData.Record(doubleSchema);
            inner.put(0, (Object)d.readDouble());
            rec.put(1, (Object)inner);
            inner = new GenericData.Record(doubleSchema);
            inner.put(0, (Object)d.readDouble());
            rec.put(2, (Object)inner);
            rec.put(3, (Object)d.readInt());
            rec.put(4, (Object)d.readInt());
            rec.put(5, (Object)d.readInt());
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private final Schema schema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \n{ \"type\": \"record\", \"name\": \"D\", \"fields\": [\n{\"name\": \"dbl\", \"type\": \"double\" }]\n} },\n{ \"name\": \"f2\", \"type\": \"D\" },\n{ \"name\": \"f3\", \"type\": \"D\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }");
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            Random r = super.getRandom();
            for (int i = 0; i < this.getBatchSize(); ++i) {
                encoder.writeDouble(r.nextDouble());
                encoder.writeDouble(r.nextDouble());
                encoder.writeDouble(r.nextDouble());
                encoder.writeInt(r.nextInt());
                encoder.writeInt(r.nextInt());
                encoder.writeInt(r.nextInt());
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().validatingDecoder(this.schema, super.newDecoder(this.testData));
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private final Schema schema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \n{ \"type\": \"record\", \"name\": \"D\", \"fields\": [\n{\"name\": \"dbl\", \"type\": \"double\" }]\n} },\n{ \"name\": \"f2\", \"type\": \"D\" },\n{ \"name\": \"f3\", \"type\": \"D\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }");
        private GenericRecord[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new GenericRecord[this.getBatchSize()];
            Random r = super.getRandom();
            Schema doubleSchema = ((Schema.Field)this.schema.getFields().get(0)).schema();
            for (int i = 0; i < this.testData.length; ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                GenericData.Record inner = new GenericData.Record(doubleSchema);
                inner.put(0, (Object)r.nextDouble());
                rec.put(0, (Object)inner);
                inner = new GenericData.Record(doubleSchema);
                inner.put(0, (Object)r.nextDouble());
                rec.put(1, (Object)inner);
                inner = new GenericData.Record(doubleSchema);
                inner.put(0, (Object)r.nextDouble());
                rec.put(2, (Object)inner);
                rec.put(3, (Object)r.nextInt());
                rec.put(4, (Object)r.nextInt());
                rec.put(5, (Object)r.nextInt());
                this.testData[i] = rec;
            }
        }
    }
}

