/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class Util {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    Util() {
    }

    static BufferedInputStream fileOrStdin(String filename, InputStream stdin) throws IOException {
        return new BufferedInputStream(filename.equals("-") ? stdin : Util.openFromFS(filename));
    }

    static BufferedOutputStream fileOrStdout(String filename, OutputStream stdout) throws IOException {
        return new BufferedOutputStream(filename.equals("-") ? stdout : Util.createFromFS(filename));
    }

    static InputStream openFromFS(String filename) throws IOException {
        Path p = new Path(filename);
        return p.getFileSystem(new Configuration()).open(p);
    }

    static InputStream openFromFS(Path filename) throws IOException {
        return filename.getFileSystem(new Configuration()).open(filename);
    }

    static FsInput openSeekableFromFS(String filename) throws IOException {
        return new FsInput(new Path(filename), new Configuration());
    }

    static OutputStream createFromFS(String filename) throws IOException {
        Path p = new Path(filename);
        return new BufferedOutputStream((OutputStream)p.getFileSystem(new Configuration()).create(p));
    }

    static void close(InputStream in) {
        if (!System.in.equals(in)) {
            try {
                in.close();
            }
            catch (IOException e) {
                System.err.println("could not close InputStream " + in.toString());
            }
        }
    }

    static void close(OutputStream out) {
        if (!System.out.equals(out)) {
            try {
                out.close();
            }
            catch (IOException e) {
                System.err.println("could not close OutputStream " + out.toString());
            }
        }
    }

    static Schema parseSchemaFromFS(String filename) throws IOException {
        InputStream stream = Util.openFromFS(filename);
        try {
            Schema schema = new Schema.Parser().parse(stream);
            return schema;
        }
        finally {
            Util.close(stream);
        }
    }

    static List<Path> getFiles(String fileOrDirName) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        Path path = new Path(fileOrDirName);
        FileSystem fs = path.getFileSystem(new Configuration());
        if (fs.isFile(path)) {
            pathList.add(path);
        } else if (fs.isDirectory(path)) {
            for (FileStatus status : fs.listStatus(path)) {
                if (status.isDirectory()) continue;
                pathList.add(status.getPath());
            }
        } else {
            FileStatus[] fileStatuses = fs.globStatus(path);
            if (fileStatuses != null) {
                for (FileStatus status : fileStatuses) {
                    pathList.add(status.getPath());
                }
            } else {
                throw new FileNotFoundException(fileOrDirName);
            }
        }
        Collections.sort(pathList);
        return pathList;
    }

    static List<Path> getFiles(List<String> fileOrDirNames) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (String name : fileOrDirNames) {
            pathList.addAll(Util.getFiles(name));
        }
        Collections.sort(pathList);
        return pathList;
    }

    static Object jsonToGenericDatum(Schema schema, String jsonData) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(schema);
        Object datum = reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(schema, jsonData));
        return datum;
    }

    static Object datumFromFile(Schema schema, String file) throws IOException {
        try (DataFileReader in = new DataFileReader(new File(file), (DatumReader)new GenericDatumReader(schema));){
            Object object = in.next();
            return object;
        }
    }

    static OptionSpec<String> compressionCodecOption(OptionParser optParser) {
        return optParser.accepts("codec", "Compression codec").withRequiredArg().ofType(String.class).defaultsTo((Object)"null", (Object[])new String[0]);
    }

    static OptionSpec<Integer> compressionLevelOption(OptionParser optParser) {
        return optParser.accepts("level", "Compression level (only applies to deflate, xz, and zstandard)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
    }

    static CodecFactory codecFactory(OptionSet opts, OptionSpec<String> codec, OptionSpec<Integer> level) {
        return Util.codecFactory(opts, codec, level, "deflate");
    }

    static CodecFactory codecFactory(OptionSet opts, OptionSpec<String> codec, OptionSpec<Integer> level, String defaultCodec) {
        String codecName;
        String string = codecName = opts.hasArgument(codec) ? (String)codec.value(opts) : defaultCodec;
        if (codecName.equals("deflate")) {
            return CodecFactory.deflateCodec((int)((Integer)level.value(opts)));
        }
        if (codecName.equals("xz")) {
            return CodecFactory.xzCodec((int)((Integer)level.value(opts)));
        }
        if (codecName.equals("zstandard")) {
            return CodecFactory.zstandardCodec((int)((Integer)level.value(opts)));
        }
        return CodecFactory.fromString((String)((String)codec.value(opts)));
    }

    static String encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & data[i]];
        }
        return new String(out);
    }
}

