/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.DataFileRepairTool;
import org.apache.avro.tool.Tool;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDataFileRepairTool {
    @ClassRule
    public static TemporaryFolder DIR = new TemporaryFolder();
    private static final Schema SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    private static File corruptBlockFile;
    private static File corruptRecordFile;
    private File repairedFile;

    @BeforeClass
    public static void writeCorruptFile() throws IOException {
        long pos;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter(SCHEMA));){
            w.create(SCHEMA, (OutputStream)baos);
            w.append((Object)new Utf8("apple"));
            w.append((Object)new Utf8("banana"));
            w.append((Object)new Utf8("celery"));
            w.sync();
            w.append((Object)new Utf8("date"));
            w.append((Object)new Utf8("endive"));
            w.append((Object)new Utf8("fig"));
            pos = w.sync();
            w.append((Object)new Utf8("guava"));
            w.append((Object)new Utf8("hazelnut"));
        }
        byte[] original = baos.toByteArray();
        int corruptPosition = (int)pos - 16;
        int corruptedBytes = 3;
        byte[] corrupted = new byte[original.length + corruptedBytes];
        System.arraycopy(original, 0, corrupted, 0, corruptPosition);
        System.arraycopy(original, corruptPosition, corrupted, corruptPosition + corruptedBytes, original.length - corruptPosition);
        corruptBlockFile = new File(DIR.getRoot(), "corruptBlock.avro");
        corruptBlockFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(corruptBlockFile);){
            out.write(corrupted);
        }
        corruptPosition = (int)pos - 16 - (1 + "fig".length() + 1 + "endive".length());
        corrupted = new byte[original.length];
        System.arraycopy(original, 0, corrupted, 0, original.length);
        BinaryData.encodeLong((long)-1L, (byte[])corrupted, (int)corruptPosition);
        corruptRecordFile = new File(DIR.getRoot(), "corruptRecord.avro");
        corruptRecordFile.deleteOnExit();
        out = new FileOutputStream(corruptRecordFile);
        var8_12 = null;
        try {
            out.write(corrupted);
        }
        catch (Throwable throwable) {
            var8_12 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var8_12 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var8_12.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    @Before
    public void setUp() {
        this.repairedFile = new File(DIR.getRoot(), "repaired.avro");
    }

    private String run(Tool tool, String ... args) throws Exception {
        return this.run(tool, (InputStream)null, args);
    }

    private String run(Tool tool, InputStream stdin, String ... args) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream stdout = new PrintStream(out);
        tool.run(stdin, stdout, System.err, Arrays.asList(args));
        return out.toString("UTF-8").replace("\r", "");
    }

    @Test
    public void testReportCorruptBlock() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "report", corruptBlockFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 2 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 5 Number of corrupt records: 0"));
    }

    @Test
    public void testReportCorruptRecord() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "report", corruptRecordFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 3 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 8 Number of corrupt records: 2"));
    }

    @Test
    public void testRepairAllCorruptBlock() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "all", corruptBlockFile.getPath(), this.repairedFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 2 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 5 Number of corrupt records: 0"));
        this.checkFileContains(this.repairedFile, "apple", "banana", "celery", "guava", "hazelnut");
    }

    @Test
    public void testRepairAllCorruptRecord() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "all", corruptRecordFile.getPath(), this.repairedFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 3 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 8 Number of corrupt records: 2"));
        this.checkFileContains(this.repairedFile, "apple", "banana", "celery", "date", "guava", "hazelnut");
    }

    @Test
    public void testRepairPriorCorruptBlock() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "prior", corruptBlockFile.getPath(), this.repairedFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 2 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 5 Number of corrupt records: 0"));
        this.checkFileContains(this.repairedFile, "apple", "banana", "celery");
    }

    @Test
    public void testRepairPriorCorruptRecord() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "prior", corruptRecordFile.getPath(), this.repairedFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 3 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 8 Number of corrupt records: 2"));
        this.checkFileContains(this.repairedFile, "apple", "banana", "celery", "date");
    }

    @Test
    public void testRepairAfterCorruptBlock() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "after", corruptBlockFile.getPath(), this.repairedFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 2 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 5 Number of corrupt records: 0"));
        this.checkFileContains(this.repairedFile, "guava", "hazelnut");
    }

    @Test
    public void testRepairAfterCorruptRecord() throws Exception {
        String output = this.run((Tool)new DataFileRepairTool(), "-o", "after", corruptRecordFile.getPath(), this.repairedFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("Number of blocks: 3 Number of corrupt blocks: 1"));
        Assert.assertTrue((String)output, (boolean)output.contains("Number of records: 8 Number of corrupt records: 2"));
        this.checkFileContains(this.repairedFile, "guava", "hazelnut");
    }

    private void checkFileContains(File repairedFile, String ... lines) throws IOException {
        DataFileReader r = new DataFileReader(repairedFile, (DatumReader)new GenericDatumReader(SCHEMA));
        for (String line : lines) {
            Assert.assertEquals((Object)line, (Object)r.next().toString());
        }
        Assert.assertFalse((boolean)r.hasNext());
    }
}

