/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.tool.BinaryFragmentToJsonTool;
import org.apache.avro.tool.JsonToBinaryFragmentTool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestJsonToFromBinaryFragmentTools {
    private static final String STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING).toString();
    private static final String UTF8 = "utf-8";
    private static final String AVRO = "ZLong string implies readable length encoding.";
    private static final String JSON = "\"Long string implies readable length encoding.\"\n";
    @Rule
    public TemporaryFolder DIR = new TemporaryFolder();

    @Test
    public void testBinaryToJson() throws Exception {
        this.binaryToJson(AVRO, JSON, STRING_SCHEMA);
    }

    @Test
    public void testJsonToBinary() throws Exception {
        this.jsonToBinary(JSON, AVRO, STRING_SCHEMA);
    }

    @Test
    public void testMultiBinaryToJson() throws Exception {
        this.binaryToJson("ZLong string implies readable length encoding.ZLong string implies readable length encoding.ZLong string implies readable length encoding.", "\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n", STRING_SCHEMA);
    }

    @Test
    public void testMultiJsonToBinary() throws Exception {
        this.jsonToBinary("\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n", "ZLong string implies readable length encoding.ZLong string implies readable length encoding.ZLong string implies readable length encoding.", STRING_SCHEMA);
    }

    @Test
    public void testBinaryToNoPrettyJson() throws Exception {
        this.binaryToJson(AVRO, JSON, "--no-pretty", STRING_SCHEMA);
    }

    @Test
    public void testMultiBinaryToNoPrettyJson() throws Exception {
        this.binaryToJson("ZLong string implies readable length encoding.ZLong string implies readable length encoding.ZLong string implies readable length encoding.", "\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n\"Long string implies readable length encoding.\"\n", "--no-pretty", STRING_SCHEMA);
    }

    @Test
    public void testBinaryToJsonSchemaFile() throws Exception {
        this.binaryToJson(AVRO, JSON, "--schema-file", TestJsonToFromBinaryFragmentTools.schemaFile(this.DIR.getRoot()));
    }

    @Test
    public void testJsonToBinarySchemaFile() throws Exception {
        this.jsonToBinary(JSON, AVRO, "--schema-file", TestJsonToFromBinaryFragmentTools.schemaFile(this.DIR.getRoot()));
    }

    private void binaryToJson(String avro, String json, String ... options) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(new BufferedOutputStream(baos));
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(options));
        args.add("-");
        new BinaryFragmentToJsonTool().run((InputStream)new ByteArrayInputStream(avro.getBytes(StandardCharsets.UTF_8)), p, null, args);
        System.out.println(baos.toString(UTF8).replace("\r", ""));
        Assert.assertEquals((Object)json, (Object)baos.toString(UTF8).replace("\r", ""));
    }

    private void jsonToBinary(String json, String avro, String ... options) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(new BufferedOutputStream(baos));
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(options));
        args.add("-");
        new JsonToBinaryFragmentTool().run((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), p, null, args);
        Assert.assertEquals((Object)avro, (Object)baos.toString(UTF8));
    }

    private static String schemaFile(File dir) throws IOException {
        File schemaFile = new File(dir, "String.avsc");
        try (FileWriter fw = new FileWriter(schemaFile);){
            fw.append(STRING_SCHEMA);
        }
        return schemaFile.toString();
    }
}

