/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.RecodecTool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestRecodecTool {
    @Rule
    public TemporaryFolder DIR = new TemporaryFolder();

    @Test
    public void testRecodec() throws Exception {
        String metaKey = "myMetaKey";
        String metaValue = "myMetaValue";
        File inputFile = new File(this.DIR.getRoot(), "input.avro");
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema)).setMeta(metaKey, metaValue).create(schema, inputFile);
        for (int i = 0; i < 100000; ++i) {
            writer.append((Object)("" + i % 100));
        }
        writer.close();
        File defaultOutputFile = new File(this.DIR.getRoot(), "default-output.avro");
        File nullOutputFile = new File(this.DIR.getRoot(), "null-output.avro");
        File deflateDefaultOutputFile = new File(this.DIR.getRoot(), "deflate-default-output.avro");
        File deflate1OutputFile = new File(this.DIR.getRoot(), "deflate-1-output.avro");
        File deflate9OutputFile = new File(this.DIR.getRoot(), "deflate-9-output.avro");
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(defaultOutputFile), null, new ArrayList());
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(nullOutputFile), null, Collections.singletonList("--codec=null"));
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(deflateDefaultOutputFile), null, Collections.singletonList("--codec=deflate"));
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(deflate1OutputFile), null, Arrays.asList("--codec=deflate", "--level=1"));
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(deflate9OutputFile), null, Arrays.asList("--codec=deflate", "--level=9"));
        Assert.assertEquals((Object)metaValue, (Object)new DataFileReader(defaultOutputFile, (DatumReader)new GenericDatumReader()).getMetaString(metaKey));
        Assert.assertEquals((long)defaultOutputFile.length(), (long)nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflateDefaultOutputFile.length(), nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflate1OutputFile.length(), nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflate9OutputFile.length(), nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflate9OutputFile.length(), deflate1OutputFile.length());
    }

    private static void assertLessThan(long less, long more) {
        if (less >= more) {
            Assert.fail((String)("Expected " + less + " to be less than " + more));
        }
    }
}

