/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.ToTrevniTool;
import org.apache.avro.tool.Util;
import org.apache.avro.util.RandomData;
import org.apache.trevni.avro.AvroColumnReader;
import org.junit.Assert;
import org.junit.Test;

public class TestToTrevniTool {
    private static final long SEED = System.currentTimeMillis();
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "200"));
    private static final File DIR = new File("/tmp");
    private static final File AVRO_FILE = new File(DIR, "random.avro");
    private static final File TREVNI_FILE = new File(DIR, "random.trv");
    private static final File SCHEMA_FILE = new File("../../../share/test/schemas/weather.avsc");

    private String run(String ... args) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(baos);
        new ToTrevniTool().run(null, p, null, Arrays.asList(args));
        return baos.toString("UTF-8").replace("\r", "");
    }

    @Test
    public void test() throws Exception {
        Schema schema = new Schema.Parser().parse(SCHEMA_FILE);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        writer.create(schema, Util.createFromFS((String)AVRO_FILE.toString()));
        for (Object datum : new RandomData(schema, COUNT, SEED)) {
            writer.append(datum);
        }
        writer.close();
        this.run(AVRO_FILE.toString(), TREVNI_FILE.toString());
        AvroColumnReader reader = new AvroColumnReader(new AvroColumnReader.Params(TREVNI_FILE));
        Iterator found = reader.iterator();
        for (Object expected : new RandomData(schema, COUNT, SEED)) {
            Assert.assertEquals(expected, found.next());
        }
        reader.close();
    }
}

