/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class DataFileReadTool
implements Tool {
    private static final long DEFAULT_HEAD_COUNT = 10L;

    @Override
    public String getName() {
        return "tojson";
    }

    @Override
    public String getShortDescription() {
        return "Dumps an Avro data file as JSON, record per line or pretty.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder prettyOption = optionParser.accepts("pretty", "Turns on pretty printing.");
        String headDesc = String.format("Converts the first X records (default is %d).", 10L);
        ArgumentAcceptingOptionSpec headOption = optionParser.accepts("head", headDesc).withOptionalArg();
        OptionSet optionSet = optionParser.parse(args.toArray(new String[0]));
        Boolean pretty = optionSet.has((OptionSpec)prettyOption);
        ArrayList<String> nargs = new ArrayList<String>(optionSet.nonOptionArguments());
        long headCount = DataFileReadTool.getHeadCount(optionSet, (OptionSpec<String>)headOption, nargs);
        if (nargs.size() != 1) {
            this.printHelp(err);
            err.println();
            optionParser.printHelpOn((OutputStream)err);
            return 1;
        }
        BufferedInputStream inStream = Util.fileOrStdin((String)nargs.get(0), stdin);
        GenericDatumReader reader = new GenericDatumReader();
        Throwable throwable = null;
        Object var17_17 = null;
        try (DataFileStream streamReader = new DataFileStream((InputStream)inStream, (DatumReader)reader);){
            Schema schema = streamReader.getSchema();
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out, pretty.booleanValue());
            long recordCount = 0L;
            while (streamReader.hasNext() && recordCount < headCount) {
                Object datum = streamReader.next();
                writer.write(datum, (Encoder)encoder);
                ++recordCount;
            }
            encoder.flush();
            out.println();
            out.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return 0;
    }

    private static long getHeadCount(OptionSet optionSet, OptionSpec<String> headOption, List<String> nargs) {
        long headCount = Long.MAX_VALUE;
        if (optionSet.has(headOption)) {
            headCount = 10L;
            List headValues = optionSet.valuesOf(headOption);
            if (headValues.size() > 0) {
                try {
                    headCount = Long.parseLong((String)headValues.get(0));
                    if (headCount < 0L) {
                        throw new AvroRuntimeException("--head count must not be negative");
                    }
                }
                catch (NumberFormatException ex) {
                    nargs.addAll(headValues);
                }
            }
        }
        return headCount;
    }

    private void printHelp(PrintStream ps) {
        ps.println("tojson [--pretty] [--head[=X]] input-file");
        ps.println();
        ps.println(this.getShortDescription());
        ps.println("A dash ('-') can be given as an input file to use stdin");
    }
}

