/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.tool.BinaryFragmentToJsonTool;
import org.apache.avro.tool.CatTool;
import org.apache.avro.tool.ConcatTool;
import org.apache.avro.tool.CreateRandomFileTool;
import org.apache.avro.tool.DataFileGetMetaTool;
import org.apache.avro.tool.DataFileGetSchemaTool;
import org.apache.avro.tool.DataFileReadTool;
import org.apache.avro.tool.DataFileRepairTool;
import org.apache.avro.tool.DataFileWriteTool;
import org.apache.avro.tool.FromTextTool;
import org.apache.avro.tool.IdlToSchemataTool;
import org.apache.avro.tool.IdlTool;
import org.apache.avro.tool.InduceSchemaTool;
import org.apache.avro.tool.JsonToBinaryFragmentTool;
import org.apache.avro.tool.RecodecTool;
import org.apache.avro.tool.RpcProtocolTool;
import org.apache.avro.tool.RpcReceiveTool;
import org.apache.avro.tool.RpcSendTool;
import org.apache.avro.tool.SchemaFingerprintTool;
import org.apache.avro.tool.SchemaNormalizationTool;
import org.apache.avro.tool.SpecificCompilerTool;
import org.apache.avro.tool.TetherTool;
import org.apache.avro.tool.ToTextTool;
import org.apache.avro.tool.ToTrevniTool;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.TrevniCreateRandomTool;
import org.apache.avro.tool.TrevniMetadataTool;
import org.apache.avro.tool.TrevniToJsonTool;

public class Main {
    final Map<String, Tool> tools = new TreeMap<String, Tool>();
    int maxLen = 0;

    Main() {
        Tool[] toolArray = new Tool[]{new CatTool(), new SpecificCompilerTool(), new InduceSchemaTool(), new JsonToBinaryFragmentTool(), new BinaryFragmentToJsonTool(), new CreateRandomFileTool(), new DataFileReadTool(), new DataFileWriteTool(), new DataFileGetMetaTool(), new DataFileGetSchemaTool(), new DataFileRepairTool(), new IdlTool(), new IdlToSchemataTool(), new RecodecTool(), new ConcatTool(), new RpcReceiveTool(), new RpcSendTool(), new RpcProtocolTool(), new FromTextTool(), new ToTextTool(), new ToTrevniTool(), new TetherTool(), new TrevniCreateRandomTool(), new TrevniMetadataTool(), new TrevniToJsonTool(), new SchemaNormalizationTool(), new SchemaFingerprintTool()};
        int n = toolArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tool tool = toolArray[n2];
            Tool prev = this.tools.put(tool.getName(), tool);
            if (prev != null) {
                throw new AssertionError((Object)("Two tools with identical names: " + tool + ", " + prev));
            }
            this.maxLen = Math.max(tool.getName().length(), this.maxLen);
            ++n2;
        }
    }

    public static void main(String[] args) throws Exception {
        int rc = new Main().run(args);
        System.exit(rc);
    }

    private int run(String[] args) throws Exception {
        Object tool;
        if (args.length != 0 && (tool = this.tools.get(args[0])) != null) {
            return tool.run(System.in, System.out, System.err, Arrays.asList(args).subList(1, args.length));
        }
        System.err.print("Version ");
        tool = null;
        Iterator<Tool> iterator = null;
        try (InputStream versionInput = Main.class.getClassLoader().getResourceAsStream("VERSION.txt");){
            Main.printStream(versionInput);
        }
        catch (Throwable throwable) {
            if (tool == null) {
                tool = throwable;
            } else if (tool != throwable) {
                ((Throwable)tool).addSuppressed(throwable);
            }
            throw tool;
        }
        System.err.print(" of ");
        tool = null;
        iterator = null;
        try (InputStream noticeInput = Main.class.getClassLoader().getResourceAsStream("META-INF/NOTICE");){
            Main.printHead(noticeInput, 5);
        }
        catch (Throwable throwable) {
            if (tool == null) {
                tool = throwable;
            } else if (tool != throwable) {
                ((Throwable)tool).addSuppressed(throwable);
            }
            throw tool;
        }
        System.err.println("----------------");
        System.err.println("Available tools:");
        for (Tool k : this.tools.values()) {
            System.err.printf("%" + this.maxLen + "s  %s\n", k.getName(), k.getShortDescription());
        }
        return 1;
    }

    private static void printStream(InputStream in) throws Exception {
        byte[] buffer = new byte[1024];
        int i = in.read(buffer);
        while (i != -1) {
            System.err.write(buffer, 0, i);
            i = in.read(buffer);
        }
    }

    private static void printHead(InputStream in, int lines) throws Exception {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        int i = 0;
        while (i < lines) {
            String line = r.readLine();
            if (line == null) break;
            System.err.println(line);
            ++i;
        }
    }
}

