/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.tool.Tool;

public class SpecificCompilerTool
implements Tool {
    private static final FileExtensionFilter SCHEMA_FILTER = new FileExtensionFilter("avsc");
    private static final FileExtensionFilter PROTOCOL_FILTER = new FileExtensionFilter("avpr");

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() < 3) {
            System.err.println("Usage: [-encoding <outputencoding>] [-string] [-bigDecimal] [-dateTimeLogicalTypeImpl <dateTimeType>] [-templateDir <templateDir>] (schema|protocol) input... outputdir");
            System.err.println(" input - input files or directories");
            System.err.println(" outputdir - directory to write generated java");
            System.err.println(" -encoding <outputencoding> - set the encoding of output file(s)");
            System.err.println(" -string - use java.lang.String instead of Utf8");
            System.err.println(" -bigDecimal - use java.math.BigDecimal for decimal type instead of java.nio.ByteBuffer");
            System.err.println(" -dateTimeLogicalTypeImpl [jsr310|joda] - use either Java 8 native date/time classes (JSR 310)(default) or Joda time classes");
            System.err.println(" -templateDir - directory with custom Velocity templates");
            return 1;
        }
        GenericData.StringType stringType = GenericData.StringType.CharSequence;
        boolean useLogicalDecimal = false;
        Optional<Object> dateTimeLogicalTypeImplementation = Optional.empty();
        Optional<String> encoding = Optional.empty();
        Optional<String> templateDir = Optional.empty();
        int arg = 0;
        if ("-encoding".equals(args.get(arg))) {
            encoding = Optional.of(args.get(++arg));
            ++arg;
        }
        if ("-string".equals(args.get(arg))) {
            stringType = GenericData.StringType.String;
            ++arg;
        }
        if ("-bigDecimal".equalsIgnoreCase(args.get(arg))) {
            useLogicalDecimal = true;
            ++arg;
        }
        if ("-dateTimeLogicalTypeImpl".equalsIgnoreCase(args.get(arg))) {
            ++arg;
            try {
                dateTimeLogicalTypeImplementation = Optional.of(SpecificCompiler.DateTimeLogicalTypeImplementation.valueOf((String)args.get(arg).toUpperCase()));
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                System.err.println("Expected one of " + Arrays.toString(SpecificCompiler.DateTimeLogicalTypeImplementation.values()));
                return 1;
            }
            ++arg;
        }
        if ("-templateDir".equals(args.get(arg))) {
            templateDir = Optional.of(args.get(++arg));
            ++arg;
        }
        String method = args.get(arg);
        ArrayList<File> inputs = new ArrayList<File>();
        File output = new File(args.get(args.size() - 1));
        int i = arg + 1;
        while (i < args.size() - 1) {
            inputs.add(new File(args.get(i)));
            ++i;
        }
        if ("schema".equals(method)) {
            Schema.Parser parser = new Schema.Parser();
            File[] fileArray = SpecificCompilerTool.determineInputs(inputs, SCHEMA_FILTER);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File src = fileArray[n2];
                Schema schema = parser.parse(src);
                SpecificCompiler compiler = new SpecificCompiler(schema, (SpecificCompiler.DateTimeLogicalTypeImplementation)dateTimeLogicalTypeImplementation.orElse(SpecificCompiler.DateTimeLogicalTypeImplementation.DEFAULT));
                this.executeCompiler(compiler, encoding, stringType, useLogicalDecimal, templateDir, src, output);
                ++n2;
            }
        } else if ("protocol".equals(method)) {
            File[] fileArray = SpecificCompilerTool.determineInputs(inputs, PROTOCOL_FILTER);
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File src = fileArray[n3];
                Protocol protocol = Protocol.parse((File)src);
                SpecificCompiler compiler = new SpecificCompiler(protocol, dateTimeLogicalTypeImplementation.orElse(SpecificCompiler.DateTimeLogicalTypeImplementation.DEFAULT));
                this.executeCompiler(compiler, encoding, stringType, useLogicalDecimal, templateDir, src, output);
                ++n3;
            }
        } else {
            System.err.println("Expected \"schema\" or \"protocol\".");
            return 1;
        }
        return 0;
    }

    private void executeCompiler(SpecificCompiler compiler, Optional<String> encoding, GenericData.StringType stringType, boolean enableDecimalLogicalType, Optional<String> templateDir, File src, File output) throws IOException {
        compiler.setStringType(stringType);
        templateDir.ifPresent(arg_0 -> ((SpecificCompiler)compiler).setTemplateDir(arg_0));
        compiler.setEnableDecimalLogicalType(enableDecimalLogicalType);
        encoding.ifPresent(arg_0 -> ((SpecificCompiler)compiler).setOutputCharacterEncoding(arg_0));
        compiler.compileToDestination(src, output);
    }

    @Override
    public String getName() {
        return "compile";
    }

    @Override
    public String getShortDescription() {
        return "Generates Java code for the given schema.";
    }

    private static File[] determineInputs(List<File> inputs, FilenameFilter filter) {
        LinkedHashSet<File> fileSet = new LinkedHashSet<File>();
        for (File file : inputs) {
            if (file.isDirectory()) {
                File[] files = file.listFiles(filter);
                Collections.addAll(fileSet, files != null ? files : new File[]{});
                continue;
            }
            fileSet.add(file);
        }
        if (fileSet.size() > 0) {
            System.err.println("Input files to compile:");
            for (File file : fileSet) {
                System.err.println("  " + file);
            }
        } else {
            System.err.println("No input files found.");
        }
        return fileSet.toArray(new File[0]);
    }

    private static class FileExtensionFilter
    implements FilenameFilter {
        private String extension;

        private FileExtensionFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

