/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.CatTool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public class TestCatTool {
    @Rule
    public TestName name = new TestName();
    @Rule
    public TemporaryFolder DIR = new TemporaryFolder();
    private static final int ROWS_IN_INPUT_FILES = 100000;
    private static final int OFFSET = 1000;
    private static final int LIMIT_WITHIN_INPUT_BOUNDS = 100;
    private static final int LIMIT_OUT_OF_INPUT_BOUNDS = 100001;
    private static final double SAMPLERATE = 0.01;
    private static final double SAMPLERATE_TOO_SMALL = 1.0E-8;
    private final Schema INTSCHEMA = new Schema.Parser().parse("{\"type\":\"record\", \"name\":\"myRecord\", \"fields\":[ {\"name\":\"value\",\"type\":\"int\"} ]}");
    private final Schema STRINGSCHEMA = new Schema.Parser().parse("{\"type\":\"record\", \"name\":\"myRecord\", \"fields\":[ {\"name\":\"value\",\"type\":\"string\"} ]}");
    private static final CodecFactory DEFLATE = CodecFactory.deflateCodec((int)9);
    private static final CodecFactory SNAPPY = CodecFactory.snappyCodec();

    private GenericRecord aDatum(Schema.Type ofType, int forRow) {
        switch (ofType) {
            case STRING: {
                GenericData.Record record = new GenericData.Record(this.STRINGSCHEMA);
                record.put("value", (Object)String.valueOf(forRow % 100));
                return record;
            }
            case INT: {
                GenericData.Record record = new GenericData.Record(this.INTSCHEMA);
                record.put("value", (Object)forRow);
                return record;
            }
        }
        throw new AssertionError((Object)"I can't generate data for this type");
    }

    private File generateData(String file, Schema.Type type, Map<String, String> metadata, CodecFactory codec) throws Exception {
        File inputFile = new File(this.DIR.getRoot(), file);
        inputFile.deleteOnExit();
        Schema schema = null;
        if (type.equals((Object)Schema.Type.INT)) {
            schema = this.INTSCHEMA;
        }
        if (type.equals((Object)Schema.Type.STRING)) {
            schema = this.STRINGSCHEMA;
        }
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        for (Map.Entry<String, String> metadatum : metadata.entrySet()) {
            writer.setMeta(metadatum.getKey(), metadatum.getValue());
        }
        writer.setCodec(codec);
        writer.create(schema, inputFile);
        int i = 0;
        while (i < 100000) {
            writer.append((Object)this.aDatum(type, i));
            ++i;
        }
        writer.close();
        return inputFile;
    }

    private int getFirstIntDatum(File file) throws Exception {
        DataFileStream reader = new DataFileStream((InputStream)new FileInputStream(file), (DatumReader)new GenericDatumReader());
        int result = (Integer)((GenericRecord)reader.next()).get(0);
        System.out.println(result);
        reader.close();
        return result;
    }

    private int numRowsInFile(File output) throws Exception {
        DataFileStream reader = new DataFileStream((InputStream)new FileInputStream(output), (DatumReader)new GenericDatumReader());
        Iterator rows = reader.iterator();
        int rowcount = 0;
        while (rows.hasNext()) {
            ++rowcount;
            rows.next();
        }
        reader.close();
        return rowcount;
    }

    @Test
    public void testCat() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData("input1.avro", Schema.Type.INT, metadata, DEFLATE);
        File input2 = this.generateData("input2.avro", Schema.Type.INT, metadata, SNAPPY);
        File input3 = this.generateData("input3.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.DIR.getRoot(), String.valueOf(this.name.getMethodName()) + ".avro");
        output.deleteOnExit();
        List<String> args = Arrays.asList(input1.getAbsolutePath(), input2.getAbsolutePath(), input3.getAbsolutePath(), "--offset", String.valueOf(1000), "--limit", String.valueOf(100), "--samplerate", String.valueOf(0.01), output.getAbsolutePath());
        int returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertEquals((long)100L, (long)this.numRowsInFile(output));
        args = Arrays.asList(input1.getParentFile().getAbsolutePath(), output.getAbsolutePath(), "--offset", String.valueOf(1000), "--limit", String.valueOf(100));
        returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertEquals((long)100L, (long)this.numRowsInFile(output));
        args = Arrays.asList(new File(input1.getParentFile(), "/*").getAbsolutePath(), output.getAbsolutePath(), "--offset", String.valueOf(1000), "--limit", String.valueOf(100));
        returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertEquals((long)100L, (long)this.numRowsInFile(output));
    }

    @Test
    public void testLimitOutOfBounds() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData("input1.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.DIR.getRoot(), String.valueOf(this.name.getMethodName()) + ".avro");
        output.deleteOnExit();
        List<String> args = Arrays.asList(input1.getAbsolutePath(), "--offset=" + String.valueOf(1000), "--limit=" + String.valueOf(100001), output.getAbsolutePath());
        int returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertEquals((long)99000L, (long)this.numRowsInFile(output));
    }

    @Test
    public void testSamplerateAccuracy() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData("input1.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.DIR.getRoot(), String.valueOf(this.name.getMethodName()) + ".avro");
        output.deleteOnExit();
        List<String> args = Arrays.asList(input1.getAbsolutePath(), output.getAbsolutePath(), "--offset", String.valueOf(1000), "--samplerate", String.valueOf(0.01));
        int returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertTrue((String)"Outputsize is not roughly (Inputsize - Offset) * samplerate", (990.0 - (double)this.numRowsInFile(output) < 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"", (990.0 - (double)this.numRowsInFile(output) > -2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testOffSetAccuracy() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData("input1.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.DIR.getRoot(), String.valueOf(this.name.getMethodName()) + ".avro");
        output.deleteOnExit();
        List<String> args = Arrays.asList(input1.getAbsolutePath(), "--offset", String.valueOf(1000), "--limit", String.valueOf(100), "--samplerate", String.valueOf(0.01), output.getAbsolutePath());
        int returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertEquals((String)"output does not start at offset", (long)1000L, (long)this.getFirstIntDatum(output));
    }

    @Test
    public void testOffsetBiggerThanInput() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData("input1.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.DIR.getRoot(), String.valueOf(this.name.getMethodName()) + ".avro");
        output.deleteOnExit();
        List<String> args = Arrays.asList(input1.getAbsolutePath(), "--offset", String.valueOf(100001), output.getAbsolutePath());
        int returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertEquals((String)"output is not empty", (long)0L, (long)this.numRowsInFile(output));
    }

    @Test
    public void testSamplerateSmallerThanInput() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData("input1.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.DIR.getRoot(), String.valueOf(this.name.getMethodName()) + ".avro");
        output.deleteOnExit();
        List<String> args = Arrays.asList(input1.getAbsolutePath(), output.getAbsolutePath(), "--offset=" + Integer.toString(1000), "--samplerate=" + Double.toString(1.0E-8));
        int returnCode = new CatTool().run(System.in, System.out, System.err, args);
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertEquals((String)"output should only contain the record at offset", (long)1000L, (long)this.getFirstIntDatum(output));
    }

    @Test(expected=IOException.class)
    public void testDifferentSchemasFail() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData("input1.avro", Schema.Type.STRING, metadata, DEFLATE);
        File input2 = this.generateData("input2.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.DIR.getRoot(), String.valueOf(this.name.getMethodName()) + ".avro");
        output.deleteOnExit();
        List<String> args = Arrays.asList(input1.getAbsolutePath(), input2.getAbsolutePath(), output.getAbsolutePath());
        new CatTool().run(System.in, System.out, System.err, args);
    }

    @Test
    public void testHelpfulMessageWhenNoArgsGiven() throws Exception {
        int returnCode;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
        Throwable throwable = null;
        Object var4_4 = null;
        try (PrintStream out = new PrintStream(buffer);){
            returnCode = new CatTool().run(System.in, out, System.err, Collections.emptyList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((long)0L, (long)returnCode);
        Assert.assertTrue((String)"should have lots of help", (buffer.toString().trim().length() > 200 ? 1 : 0) != 0);
    }
}

