/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.tool.CreateRandomFileTool;
import org.apache.avro.util.RandomData;
import org.apache.trevni.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCreateRandomFileTool {
    private static final String COUNT = System.getProperty("test.count", "200");
    private static final File DIR = new File("/tmp");
    private static final File OUT_FILE = new File(DIR, "random.avro");
    private static final File SCHEMA_FILE = new File("../../../share/test/schemas/weather.avsc");
    private final Schema.Parser schemaParser = new Schema.Parser();
    private static final long SEED = System.currentTimeMillis();
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream err;

    @Before
    public void before() {
        this.out = new ByteArrayOutputStream();
        this.err = new ByteArrayOutputStream();
    }

    @After
    public void after() throws Exception {
        this.out.close();
        this.err.close();
    }

    private int run(List<String> args) throws Exception {
        PrintStream output = new PrintStream(this.out);
        PrintStream saveOut = System.out;
        PrintStream error = new PrintStream(this.err);
        PrintStream saveErr = System.err;
        try {
            System.setOut(output);
            System.setErr(error);
            int n = new CreateRandomFileTool().run(null, output, error, args);
            return n;
        }
        finally {
            System.setOut(saveOut);
            System.setErr(saveErr);
        }
    }

    private void check(String ... extraArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(OUT_FILE.toString(), "--count", COUNT, "--schema-file", SCHEMA_FILE.toString(), "--seed", Long.toString(SEED)));
        args.addAll(Arrays.asList(extraArgs));
        this.run(args);
        DataFileReader reader = new DataFileReader(OUT_FILE, (DatumReader)new GenericDatumReader());
        Iterator found = reader.iterator();
        for (Object expected : new RandomData(this.schemaParser.parse(SCHEMA_FILE), Integer.parseInt(COUNT), SEED)) {
            Assert.assertEquals(expected, found.next());
        }
        reader.close();
    }

    private void checkMissingCount(String ... extraArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(OUT_FILE.toString(), "--schema-file", SCHEMA_FILE.toString(), "--seed", Long.toString(SEED)));
        args.addAll(Arrays.asList(extraArgs));
        this.run(args);
        Assert.assertTrue((boolean)this.err.toString().contains("Need count (--count)"));
    }

    @Test
    public void testSimple() throws Exception {
        this.check(new String[0]);
    }

    @Test
    public void testCodec() throws Exception {
        this.check("--codec", "snappy");
    }

    @Test
    public void testMissingCountParameter() throws Exception {
        this.checkMissingCount(new String[0]);
    }

    @Test
    public void testStdOut() throws Exception {
        TestUtil.resetRandomSeed();
        this.run(Arrays.asList("-", "--count", COUNT, "--schema-file", SCHEMA_FILE.toString(), "--seed", Long.toString(SEED)));
        byte[] file = this.out.toByteArray();
        DataFileStream reader = new DataFileStream((InputStream)new ByteArrayInputStream(file), (DatumReader)new GenericDatumReader());
        Iterator found = reader.iterator();
        for (Object expected : new RandomData(this.schemaParser.parse(SCHEMA_FILE), Integer.parseInt(COUNT), SEED)) {
            Assert.assertEquals(expected, found.next());
        }
        reader.close();
    }
}

