/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.DataFileGetMetaTool;
import org.apache.avro.tool.DataFileGetSchemaTool;
import org.apache.avro.tool.DataFileReadTool;
import org.apache.avro.tool.DataFileWriteTool;
import org.apache.avro.tool.Tool;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDataFileTools {
    static final int COUNT = 15;
    static File sampleFile;
    static String jsonData;
    static Schema schema;
    static File schemaFile;
    private static final String KEY_NEEDING_ESCAPES = "trn\\\r\t\n";
    private static final String ESCAPED_KEY = "trn\\\\\\r\\t\\n";
    @ClassRule
    public static TemporaryFolder DIR;

    static {
        DIR = new TemporaryFolder();
    }

    @BeforeClass
    public static void writeSampleFile() throws IOException {
        sampleFile = new File(DIR.getRoot(), String.valueOf(TestDataFileTools.class.getName()) + ".avro");
        schema = Schema.create((Schema.Type)Schema.Type.INT);
        schemaFile = new File(DIR.getRoot(), "schema-temp.schema");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (FileWriter fw = new FileWriter(schemaFile);){
            fw.append(schema.toString());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        StringBuilder builder = new StringBuilder();
        throwable2 = null;
        Object var2_5 = null;
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.setMeta(KEY_NEEDING_ESCAPES, "");
            writer.create(schema, sampleFile);
            int i = 0;
            while (i < 15) {
                builder.append(Integer.toString(i));
                builder.append("\n");
                writer.append((Object)i);
                ++i;
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        jsonData = builder.toString();
    }

    private String run(Tool tool, String ... args) throws Exception {
        return this.run(tool, (InputStream)null, args);
    }

    private String run(Tool tool, InputStream stdin, String ... args) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(baos);
        tool.run(stdin, p, null, Arrays.asList(args));
        return baos.toString("UTF-8").replace("\r", "");
    }

    @Test
    public void testRead() throws Exception {
        Assert.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), sampleFile.getPath()));
    }

    @Test
    public void testReadStdin() throws Exception {
        FileInputStream stdin = new FileInputStream(sampleFile);
        Assert.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), stdin, "-"));
    }

    @Test
    public void testReadToJsonPretty() throws Exception {
        Assert.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), "--pretty", sampleFile.getPath()));
    }

    @Test
    public void testReadHeadDefaultCount() throws Exception {
        String expectedJson = jsonData.substring(0, 20);
        Assert.assertEquals((Object)expectedJson, (Object)this.run((Tool)new DataFileReadTool(), "--head", sampleFile.getPath()));
    }

    @Test
    public void testReadHeadEquals3Count() throws Exception {
        String expectedJson = jsonData.substring(0, 6);
        Assert.assertEquals((Object)expectedJson, (Object)this.run((Tool)new DataFileReadTool(), "--head=3", sampleFile.getPath()));
    }

    @Test
    public void testReadHeadSpace5Count() throws Exception {
        String expectedJson = jsonData.substring(0, 10);
        Assert.assertEquals((Object)expectedJson, (Object)this.run((Tool)new DataFileReadTool(), "--head", "5", sampleFile.getPath()));
    }

    @Test
    public void testReadHeadLongCount() throws Exception {
        Assert.assertEquals((Object)jsonData, (Object)this.run((Tool)new DataFileReadTool(), "--head=3000000000", sampleFile.getPath()));
    }

    @Test
    public void testReadHeadEqualsZeroCount() throws Exception {
        Assert.assertEquals((Object)"\n", (Object)this.run((Tool)new DataFileReadTool(), "--head=0", sampleFile.getPath()));
    }

    @Test(expected=AvroRuntimeException.class)
    public void testReadHeadNegativeCount() throws Exception {
        Assert.assertEquals((Object)"\n", (Object)this.run((Tool)new DataFileReadTool(), "--head=-5", sampleFile.getPath()));
    }

    @Test
    public void testGetMeta() throws Exception {
        String output = this.run((Tool)new DataFileGetMetaTool(), sampleFile.getPath());
        Assert.assertTrue((String)output, (boolean)output.contains("avro.schema\t" + schema.toString() + "\n"));
        Assert.assertTrue((String)output, (boolean)output.contains("trn\\\\\\r\\t\\n\t\n"));
    }

    @Test
    public void testGetMetaForSingleKey() throws Exception {
        Assert.assertEquals((Object)(String.valueOf(schema.toString()) + "\n"), (Object)this.run((Tool)new DataFileGetMetaTool(), sampleFile.getPath(), "--key", "avro.schema"));
    }

    @Test
    public void testGetSchema() throws Exception {
        Assert.assertEquals((Object)(String.valueOf(schema.toString()) + "\n"), (Object)this.run((Tool)new DataFileGetSchemaTool(), sampleFile.getPath()));
    }

    @Test
    public void testWriteWithDeflate() throws Exception {
        this.testWrite("deflate", Arrays.asList("--codec", "deflate"), "deflate");
    }

    @Test
    public void testWrite() throws Exception {
        this.testWrite("plain", Collections.emptyList(), "null");
    }

    public void testWrite(String name, List<String> extra, String expectedCodec) throws Exception {
        this.testWrite(name, extra, expectedCodec, "-schema", schema.toString());
        this.testWrite(name, extra, expectedCodec, "-schema-file", schemaFile.toString());
    }

    public void testWrite(String name, List<String> extra, String expectedCodec, String ... extraArgs) throws Exception {
        File outFile = new File(DIR.getRoot(), TestDataFileTools.class + ".testWrite." + name + ".avro");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (FileOutputStream fout = new FileOutputStream(outFile);){
            Throwable throwable3 = null;
            Object var10_15 = null;
            try (PrintStream out = new PrintStream(fout);){
                ArrayList<String> args = new ArrayList<String>();
                Collections.addAll(args, extraArgs);
                args.add("-");
                args.addAll(extra);
                new DataFileWriteTool().run((InputStream)new ByteArrayInputStream(jsonData.getBytes("UTF-8")), new PrintStream(out), null, args);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        GenericDatumReader reader = new GenericDatumReader();
        throwable2 = null;
        Object var8_11 = null;
        try (DataFileReader fileReader = new DataFileReader(outFile, (DatumReader)reader);){
            int i = 0;
            for (Object datum : fileReader) {
                Assert.assertEquals((Object)i, datum);
                ++i;
            }
            Assert.assertEquals((long)15L, (long)i);
            Assert.assertEquals((Object)schema, (Object)fileReader.getSchema());
            String codecStr = fileReader.getMetaString("avro.codec");
            if (codecStr == null) {
                codecStr = "null";
            }
            Assert.assertEquals((Object)expectedCodec, (Object)codecStr);
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
    }

    @Test(expected=IOException.class)
    public void testFailureOnWritingPartialJSONValues() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        new DataFileWriteTool().run((InputStream)new ByteArrayInputStream("{".getBytes("UTF-8")), new PrintStream(out), null, Arrays.asList("-schema", "{ \"type\":\"record\", \"fields\":[{\"name\":\"foo\", \"type\":\"string\"}], \"name\":\"boring\" }", "-"));
    }

    @Test
    public void testWritingZeroJsonValues() throws Exception {
        File outFile = this.writeToAvroFile("zerojsonvalues", schema.toString(), "");
        Assert.assertEquals((long)0L, (long)this.countRecords(outFile));
    }

    private int countRecords(File outFile) throws IOException {
        GenericDatumReader reader = new GenericDatumReader();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataFileReader fileReader = new DataFileReader(outFile, (DatumReader)reader);){
            int i = 0;
            for (Object datum : fileReader) {
                ++i;
            }
            return i;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testDifferentSeparatorsBetweenJsonRecords() throws Exception {
        File outFile = this.writeToAvroFile("separators", "{ \"type\":\"array\", \"items\":\"int\" }", "[]    [] []\n[][3]     ");
        Assert.assertEquals((long)5L, (long)this.countRecords(outFile));
    }

    public File writeToAvroFile(String testName, String schema, String json) throws Exception {
        File outFile = new File(DIR.getRoot(), TestDataFileTools.class + "." + testName + ".avro");
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream fout = new FileOutputStream(outFile);){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (PrintStream out = new PrintStream(fout);){
                new DataFileWriteTool().run((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")), new PrintStream(out), null, Arrays.asList("-schema", schema, "-"));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return outFile;
    }
}

