/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.tool.RpcProtocolTool;
import org.apache.avro.tool.RpcReceiveTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRpcProtocolTool {
    private RpcReceiveTool receive;
    private Protocol simpleProtocol;
    private String uriScheme;

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({"http"}, {"avro"});
    }

    public TestRpcProtocolTool(String uriScheme) {
        this.uriScheme = uriScheme;
    }

    @Before
    public void setUp() throws Exception {
        String protocolFile = String.valueOf(System.getProperty("share.dir", "../../../share")) + "/test/schemas/simple.avpr";
        this.simpleProtocol = Protocol.parse((File)new File(protocolFile));
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        PrintStream p1 = new PrintStream(baos1);
        this.receive = new RpcReceiveTool();
        this.receive.run1(null, p1, System.err, Arrays.asList(String.valueOf(this.uriScheme) + "://0.0.0.0:0/", protocolFile, "hello", "-data", "\"Hello!\""));
    }

    @After
    public void tearDown() throws Exception {
        if (this.receive != null) {
            this.receive.server.close();
        }
    }

    @Test
    public void testRpcProtocol() throws Exception {
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        PrintStream p2 = new PrintStream((OutputStream)baos2, true, "UTF-8");
        RpcProtocolTool testObject = new RpcProtocolTool();
        testObject.run(null, p2, System.err, Collections.singletonList(String.valueOf(this.uriScheme) + "://127.0.0.1:" + this.receive.server.getPort() + "/"));
        p2.flush();
        Assert.assertEquals((String)"Expected the simple.avpr protocol to be echoed to standout", (Object)this.simpleProtocol, (Object)Protocol.parse((String)baos2.toString("UTF-8")));
    }
}

