/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.avro.tool.SpecificCompilerTool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSpecificCompilerTool {
    private static final File TEST_DIR = new File(System.getProperty("test.compile.schema.dir", "src/test/compiler"));
    private static final File TEST_INPUT_DIR = new File(TEST_DIR, "input");
    private static final File TEST_EXPECTED_OUTPUT_DIR = new File(TEST_DIR, "output");
    private static final File TEST_EXPECTED_POSITION = new File(TEST_EXPECTED_OUTPUT_DIR, "Position.java");
    private static final File TEST_EXPECTED_PLAYER = new File(TEST_EXPECTED_OUTPUT_DIR, "Player.java");
    private static final File TEST_EXPECTED_STRING_OUTPUT_DIR = new File(TEST_DIR, "output-string");
    private static final File TEST_EXPECTED_STRING_POSITION = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/Position.java");
    private static final File TEST_EXPECTED_STRING_PLAYER = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/Player.java");
    private static final File TEST_EXPECTED_STRING_FIELDTEST = new File(TEST_EXPECTED_STRING_OUTPUT_DIR, "avro/examples/baseball/FieldTest.java");
    private static final File TEST_OUTPUT_DIR = new File("target/compiler/output");
    private static final File TEST_OUTPUT_PLAYER = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/Player.java");
    private static final File TEST_OUTPUT_POSITION = new File(TEST_OUTPUT_DIR, "avro/examples/baseball/Position.java");
    private static final File TEST_OUTPUT_STRING_DIR = new File("target/compiler/output-string");
    private static final File TEST_OUTPUT_STRING_PLAYER = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/Player.java");
    private static final File TEST_OUTPUT_STRING_POSITION = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/Position.java");
    private static final File TEST_OUTPUT_STRING_FIELDTEST = new File(TEST_OUTPUT_STRING_DIR, "avro/examples/baseball/FieldTest.java");

    @Before
    public void setUp() {
        TEST_OUTPUT_DIR.delete();
    }

    @Test
    public void testCompileSchemaSingleFile() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "schema", String.valueOf(TEST_INPUT_DIR.toString()) + "/position.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_POSITION, TEST_OUTPUT_POSITION);
    }

    @Test
    public void testCompileSchemaTwoFiles() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "schema", String.valueOf(TEST_INPUT_DIR.toString()) + "/position.avsc", String.valueOf(TEST_INPUT_DIR.toString()) + "/player.avsc", TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_POSITION, TEST_OUTPUT_POSITION);
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_PLAYER, TEST_OUTPUT_PLAYER);
    }

    @Test
    public void testCompileSchemaFileAndDirectory() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "schema", String.valueOf(TEST_INPUT_DIR.toString()) + "/position.avsc", TEST_INPUT_DIR.toString(), TEST_OUTPUT_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_POSITION, TEST_OUTPUT_POSITION);
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_PLAYER, TEST_OUTPUT_PLAYER);
    }

    @Test
    public void testCompileSchemasUsingString() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "-string", "schema", String.valueOf(TEST_INPUT_DIR.toString()) + "/position.avsc", String.valueOf(TEST_INPUT_DIR.toString()) + "/player.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_POSITION, TEST_OUTPUT_STRING_POSITION);
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_PLAYER, TEST_OUTPUT_STRING_PLAYER);
    }

    @Test
    public void testCompileSchemasWithVariousFieldTypes() throws Exception {
        this.doCompile(new String[]{"-encoding", "UTF-8", "-string", "schema", String.valueOf(TEST_INPUT_DIR.toString()) + "/fieldtest.avsc", String.valueOf(TEST_INPUT_DIR.toString()) + "/fieldtest.avsc", TEST_OUTPUT_STRING_DIR.getPath()});
        TestSpecificCompilerTool.assertFileMatch(TEST_EXPECTED_STRING_FIELDTEST, TEST_OUTPUT_STRING_FIELDTEST);
    }

    private void doCompile(String[] args) throws Exception {
        SpecificCompilerTool tool = new SpecificCompilerTool();
        tool.run(null, null, null, Arrays.asList(args));
    }

    private static void assertFileMatch(File expected, File found) throws IOException {
        Assert.assertEquals((String)("Found file: " + found + " does not match expected file: " + expected), (Object)TestSpecificCompilerTool.readFile(expected), (Object)TestSpecificCompilerTool.readFile(found));
    }

    private static String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        boolean first = true;
        while ((line = reader.readLine()) != null) {
            if (!first) {
                sb.append("\n");
                first = false;
            }
            sb.append(line);
        }
        return sb.toString();
    }
}

