/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.tool.TetherTool;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestTetherTool {
    @Rule
    public TemporaryFolder INPUT_DIR = new TemporaryFolder();
    @Rule
    public TemporaryFolder OUTPUT_DIR = new TemporaryFolder();

    @Test
    public void test() throws Exception {
        Schema outscheme = new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema();
        File midscfile = new File(this.INPUT_DIR.getRoot().getPath(), "midschema.avpr");
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter hf = new FileWriter(midscfile);){
            hf.write(outscheme.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JobConf job = new JobConf();
        String inputPathStr = this.INPUT_DIR.getRoot().getPath();
        String outputPathStr = this.OUTPUT_DIR.getRoot().getPath();
        Path outputPath = new Path(outputPathStr);
        outputPath.getFileSystem((Configuration)job).delete(outputPath, true);
        WordCountUtil.writeLinesFile((String)(String.valueOf(inputPathStr) + "/lines.avro"));
        String execargs = "-classpath " + System.getProperty("java.class.path");
        execargs = String.valueOf(execargs) + " org.apache.avro.mapred.tether.WordCountTask";
        ArrayList<String> runargs = new ArrayList<String>();
        runargs.addAll(Arrays.asList("--program", "java"));
        runargs.addAll(Arrays.asList("--exec_args", String.valueOf('\"') + execargs + '\"'));
        runargs.addAll(Arrays.asList("--exec_cached", "false"));
        runargs.addAll(Arrays.asList("--in", inputPathStr));
        runargs.addAll(Arrays.asList("--out", outputPath.toString()));
        runargs.addAll(Arrays.asList("--outschema", midscfile.toString()));
        TetherTool tool = new TetherTool();
        tool.run(null, null, System.err, runargs);
        int numWords = 0;
        SpecificDatumReader reader = new SpecificDatumReader();
        Throwable throwable3 = null;
        Object var13_16 = null;
        try (BufferedInputStream cin = new BufferedInputStream(new FileInputStream(String.valueOf(outputPathStr) + "/part-00000.avro"));){
            DataFileStream counts = new DataFileStream((InputStream)cin, (DatumReader)reader);
            for (Pair wc : counts) {
                Assert.assertEquals((String)((Utf8)wc.key()).toString(), WordCountUtil.COUNTS.get(((Utf8)wc.key()).toString()), (Object)wc.value());
                ++numWords;
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        Assert.assertEquals((long)WordCountUtil.COUNTS.size(), (long)numWords);
    }
}

